package com.taboola.android.infra.utilities;

import androidx.annotation.Keep;

import java.util.concurrent.Executor;

@Keep
public interface Executor2 extends Executor {
    /**
     * unlike {@link #execute(Runnable)}, this method may execute the given command in a blocking way if the executor deems fit to do so
     * (e.g. BackgroundExecutor will run the command immediately if not called on the UI thread) -
     * determined by {@link #canExecuteSynchronously()}
     */

    void submit(Runnable command);

    boolean canExecuteSynchronously();
}
