package com.taboola.android.infra.utilities;

import android.os.Looper;

abstract class AbstractExecutor implements Executor2 {

    @Override
    public final void submit(Runnable command) {
        if (canExecuteSynchronously()) {
            command.run();
        } else {
            execute(command);
        }
    }

    final protected boolean isThisUiThread() {
        return Thread.currentThread().equals(Looper.getMainLooper().getThread());
    }
}
