package com.taboola.android.infra.persistence;

import android.content.SharedPreferences;

import androidx.annotation.NonNull;

/**
 * Created by ronk on 2017-02-13.
 */
public class LongPersistentResource extends  AbstractPersistentResource<Long> {

    public LongPersistentResource(Builder<Long> builder) {
        super(builder);
    }

    @Override
    protected Long getStoredValue() {
        return getSharedPreferences().getLong(getStorageKey(), -1);
    }

    @Override
    protected void storeValue(@NonNull SharedPreferences.Editor editor, Long value) {
          editor.putLong(getStorageKey(), value);
    }

}
