package com.taboola.android.infra.persistence;

import android.content.Context;
import android.content.SharedPreferences;

import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.arch.core.util.Function;

public  class BuilderWithContext<T> implements AbstractPersistentResource.Builder<T> {
    @StringRes
    private final int storageKey;
    private final Context context;
    private final Function<Context,T> defaultValueProvider;
    private final String sharedPreferencesName;

    public BuilderWithContext(Context context, @StringRes int storageKey, String sharedPreferencesName, Function<Context, T> defaultValueProvider) {
        this.storageKey = storageKey;
        this.context = context;
        this.sharedPreferencesName = sharedPreferencesName;
        this.defaultValueProvider = defaultValueProvider;
    }

    @NonNull
    @Override
    public T getDefaultValue() {
        return defaultValueProvider.apply(context);
    }

    @NonNull
    @Override
    public String getStorageKey() {
        return context.getString(storageKey);
    }

    @NonNull
    @Override
    public SharedPreferences getSharedPreferences() {
        return context.getSharedPreferences(sharedPreferencesName,Context.MODE_PRIVATE);
    }
}
