/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils;

import android.content.res.Resources;
import android.graphics.Rect;
import android.view.View;
import com.taboola.android.utils.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class VisibilityUtil {
    private static final String TAG = VisibilityUtil.class.getSimpleName();

    public static int getVisiblePercent(View view) {
        Rect r;
        if (view.isShown() && view.getGlobalVisibleRect(r = new Rect())) {
            double sVisible = r.width() * r.height();
            double sTotal = view.getWidth() * view.getHeight();
            int percentsOnScreen = (int)(100.0 * sVisible / sTotal);
            Logger.d(TAG, "getVisiblePercent :: " + percentsOnScreen);
            return percentsOnScreen;
        }
        return -1;
    }

    public static JSONObject getViewJsonRect(View view) {
        Rect widgetRect = new Rect();
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        widgetRect.right = VisibilityUtil.convertToCssPixel(view.getWidth() + location[0]);
        widgetRect.left = VisibilityUtil.convertToCssPixel(location[0]);
        widgetRect.top = VisibilityUtil.convertToCssPixel(location[1]);
        widgetRect.bottom = VisibilityUtil.convertToCssPixel(location[1] + view.getHeight());
        return VisibilityUtil.createRectJSON(widgetRect);
    }

    public static JSONObject getScreenJsonRect() {
        int height = VisibilityUtil.convertToCssPixel(Resources.getSystem().getDisplayMetrics().heightPixels);
        int width = VisibilityUtil.convertToCssPixel(Resources.getSystem().getDisplayMetrics().widthPixels);
        Rect screenRect = new Rect();
        screenRect.bottom = height;
        screenRect.right = width;
        return VisibilityUtil.createRectJSON(screenRect);
    }

    private static JSONObject createRectJSON(Rect rect) {
        try {
            JSONObject jsonRect = new JSONObject();
            jsonRect.put("bottom", rect.bottom);
            jsonRect.put("height", rect.height());
            jsonRect.put("left", rect.left);
            jsonRect.put("right", rect.right);
            jsonRect.put("top", rect.top);
            jsonRect.put("width", rect.width());
            jsonRect.put("x", rect.left);
            jsonRect.put("y", rect.top);
            return jsonRect;
        }
        catch (JSONException e) {
            Logger.e(TAG, "createRectJSON :: " + e.toString());
            return new JSONObject();
        }
    }

    public static int convertToCssPixel(int sizeInPixel) {
        return sizeInPixel * 160 / Resources.getSystem().getDisplayMetrics().densityDpi;
    }

    public static int convertCssPixelToPixel(int cssSizeInPixel) {
        return cssSizeInPixel * Resources.getSystem().getDisplayMetrics().densityDpi / 160;
    }
}

