/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.gueh;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.v4.util.Pair;
import android.text.TextUtils;
import com.taboola.android.Taboola;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.global_components.gueh.TaboolaExceptionHandler;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.global_components.network.handlers.KibanaHandler;
import com.taboola.android.global_components.network.handlers.KustoHandler;
import com.taboola.android.global_components.network.requests.kibana.GlobalExceptionKibanaReport;
import com.taboola.android.global_components.network.requests.kusto.GlobalExceptionKustoReport;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.SharedPrefUtil;
import com.taboola.android.utils.network.KibanaUtils;
import com.taboola.lightnetwork.protocols.http.HttpError;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import com.taboola.lightnetwork.protocols.http.HttpResponse;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class SDKExceptionHandler
extends TaboolaExceptionHandler {
    private static final String TAG = SDKExceptionHandler.class.getSimpleName();
    private static final String TABOOLA_SDK_PKG = "com.taboola.android";
    private static final String TABOOLA_SDK_PLUS_PKG = "com.taboola.android.plus";
    private static final int REPORT_TIMEOUT = 5;
    private final KustoHandler mKustoHandler;
    private final KibanaHandler mKibanaHandler;
    private Context mContext;
    private NetworkManager mNetworkManager;
    private final Handler mHandler;

    public SDKExceptionHandler(Context context, NetworkManager networkManager) {
        this.mContext = context;
        this.mNetworkManager = networkManager;
        Looper looper = this.createReportLooper();
        this.mHandler = new Handler(looper);
        this.mKustoHandler = this.mNetworkManager.getKustoHandler();
        this.mKibanaHandler = this.mNetworkManager.getKibanaHandler();
    }

    private Looper createReportLooper() {
        HandlerThread handlerThread = new HandlerThread("SDKExceptionHandler");
        handlerThread.start();
        return handlerThread.getLooper();
    }

    @Override
    public boolean isHandling(Throwable throwable) {
        Throwable tmpThrowable = throwable;
        ArrayList<StackTraceElement> allElements = new ArrayList<StackTraceElement>(Arrays.asList(tmpThrowable.getStackTrace()));
        while (tmpThrowable.getCause() != null) {
            allElements.addAll(Arrays.asList(tmpThrowable.getCause().getStackTrace()));
            tmpThrowable = tmpThrowable.getCause();
        }
        return this.searchElementsForPackageName(allElements);
    }

    private boolean searchElementsForPackageName(ArrayList<StackTraceElement> elements) {
        for (StackTraceElement ste : elements) {
            if (!ste.getClassName().contains(TABOOLA_SDK_PKG) || ste.getClassName().contains(TABOOLA_SDK_PLUS_PKG)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handle(Throwable throwable) {
        String exceptionMessage = throwable.getLocalizedMessage();
        Logger.e(TAG, "Exception message: " + exceptionMessage);
        this.handleCrashAction(throwable, this.shouldSendCrashReportToKusto(), this.shouldSendCrashReportToKibana(throwable));
    }

    private void handleCrashAction(Throwable throwable, Integer ... reports) {
        if (reports.length == 0) {
            return;
        }
        CountDownLatch countDownLatch = new CountDownLatch(reports.length);
        block7: for (Integer action : reports) {
            switch (action) {
                case 1: {
                    this.sendExceptionToKibana(throwable, countDownLatch);
                    continue block7;
                }
                case 0: {
                    this.sendExceptionToKusto(throwable, countDownLatch);
                    continue block7;
                }
                case -1: {
                    countDownLatch.countDown();
                    continue block7;
                }
                default: {
                    countDownLatch.countDown();
                }
            }
        }
        try {
            countDownLatch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Logger.e(TAG, "handleCrashAction thread interrupted while waiting for report.");
        }
    }

    private int shouldSendCrashReportToKusto() {
        return 0;
    }

    private int shouldSendCrashReportToKibana(Throwable throwable) {
        Pair<String, String> pair = SharedPrefUtil.getLastCrashDetected(this.mContext);
        String exceptionMessage = (String)pair.first;
        String exceptionStackTrace = (String)pair.second;
        boolean thisCrashWasReported = TextUtils.equals((CharSequence)exceptionMessage, (CharSequence)throwable.getMessage()) && TextUtils.equals((CharSequence)exceptionStackTrace, (CharSequence)Arrays.toString(throwable.getStackTrace()));
        return thisCrashWasReported ? -1 : 1;
    }

    private void sendExceptionToKibana(final Throwable throwable, final CountDownLatch countDownLatch) {
        Logger.e(TAG, "Sending exception to Kibana. Message: " + throwable.getLocalizedMessage());
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                SDKExceptionHandler.this.mKibanaHandler.sendGUEHExceptionToKibana(SDKExceptionHandler.this.buildGlobalExceptionReport(throwable), new HttpManager.NetworkResponse(){

                    @Override
                    public void onResponse(HttpResponse response) {
                        Logger.d(TAG, "sendExceptionToKibana | Exception reported, response: " + response);
                        SharedPrefUtil.setLastCrashDetected(SDKExceptionHandler.this.mContext, throwable.getMessage(), Arrays.toString(throwable.getStackTrace()));
                        countDownLatch.countDown();
                    }

                    @Override
                    public void onError(HttpError error) {
                        Logger.e(TAG, "sendExceptionToKibana | Exception not reported, error: " + error);
                        countDownLatch.countDown();
                    }
                });
            }
        });
    }

    private GlobalExceptionKibanaReport buildGlobalExceptionReport(Throwable throwable) {
        String packageName = this.mContext.getPackageName();
        String exception = throwable.getLocalizedMessage();
        String sdkVer = "2.3.6-51006-2";
        String timeStamp = KibanaUtils.getISO8601currentTime();
        String deviceId = "";
        AdvertisingIdInfo advertisingIdInfo = Taboola.getTaboolaImpl().getAdvertisingIdInfo();
        if (advertisingIdInfo != null) {
            deviceId = advertisingIdInfo.getAdvertisingId();
        }
        String stackTraceString = Arrays.toString(throwable.getStackTrace());
        return new GlobalExceptionKibanaReport(packageName, exception, sdkVer, timeStamp, deviceId, stackTraceString);
    }

    private void sendExceptionToKusto(Throwable throwable, final CountDownLatch countDownLatch) {
        Logger.e(TAG, "Sending exception to Kusto.  Message: " + throwable.getLocalizedMessage());
        final GlobalExceptionKustoReport exceptionReport = new GlobalExceptionKustoReport(this.mContext, throwable);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                SDKExceptionHandler.this.mKustoHandler.sendEventToKusto(exceptionReport, new HttpManager.NetworkResponse(){

                    @Override
                    public void onResponse(HttpResponse response) {
                        Logger.d(TAG, "sendExceptionToKusto | Exception reported, response: " + response);
                        countDownLatch.countDown();
                    }

                    @Override
                    public void onError(HttpError error) {
                        Logger.e(TAG, "sendExceptionToKusto | Exception not reported, error: " + error);
                        countDownLatch.countDown();
                    }
                });
            }
        });
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ACTIONS {
        public static final int NOTHING = -1;
        public static final int KUSTO = 0;
        public static final int KIBANA = 1;
    }
}

