/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.eventsmanager;

import android.support.annotation.Keep;
import android.text.TextUtils;
import com.taboola.android.utils.Logger;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class SessionInfo {
    private static final String TAG = SessionInfo.class.getSimpleName();
    private static final String SERVER_SESSION_INFO_KEY_SESSION_ID = "session";
    private static final String SERVER_SESSION_INFO_KEY_RESPONSE_ID = "id";
    private String mSessionId;
    private String mResponseId;

    public SessionInfo(String sessionId, String responseId) {
        this.mSessionId = sessionId;
        this.mResponseId = responseId;
    }

    public SessionInfo(String serverSessionInfo) {
        try {
            JSONObject sessionInfoJson = new JSONObject(serverSessionInfo);
            this.mSessionId = sessionInfoJson.getString(SERVER_SESSION_INFO_KEY_SESSION_ID);
            this.mResponseId = sessionInfoJson.getString(SERVER_SESSION_INFO_KEY_RESPONSE_ID);
        }
        catch (JSONException je) {
            Logger.e(TAG, je.getLocalizedMessage());
        }
        catch (NullPointerException npe) {
            Logger.e(TAG, npe.getLocalizedMessage());
        }
    }

    public synchronized boolean isValid() {
        return !TextUtils.isEmpty((CharSequence)this.mSessionId) && !TextUtils.isEmpty((CharSequence)this.mResponseId);
    }

    public synchronized String getSessionId() {
        return this.mSessionId;
    }

    public synchronized void setSessionId(String sessionId) {
        this.mSessionId = sessionId;
    }

    public synchronized String getResponseId() {
        return this.mResponseId;
    }

    public synchronized void setResponseId(String responseId) {
        this.mResponseId = responseId;
    }
}

