/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.lightnetwork.url_components;

import android.net.Uri;
import android.text.TextUtils;
import com.taboola.lightnetwork.url_components.PathParam;
import com.taboola.lightnetwork.url_components.UrlParameter;
import com.taboola.lightnetwork.url_components.UrlParameters;
import java.util.ArrayList;

public class MutableUrl {
    private static final String STRUCTURE = "%s%s";
    private static final boolean UTF8_BY_DEFAULT = true;
    private String mBaseUrl;
    private UrlParameters mQueryParameters;
    private ArrayList<PathParam> mPathParams;

    public MutableUrl(String baseUrl) {
        if (TextUtils.isEmpty((CharSequence)baseUrl)) {
            throw new RuntimeException("constructor | baseUrl cannot be null.");
        }
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        this.mBaseUrl = baseUrl;
    }

    public MutableUrl addPathParam(PathParam pathParam) {
        if (this.mPathParams == null) {
            this.mPathParams = new ArrayList();
        }
        this.mPathParams.add(pathParam);
        return this;
    }

    private String getBaseUrlWithParams() {
        String baseUrl = this.mBaseUrl;
        if (this.mPathParams != null) {
            for (PathParam pathParam : this.mPathParams) {
                baseUrl = baseUrl.replace(pathParam.getOldVal(), Uri.encode((String)pathParam.getNewVal()));
            }
        }
        return baseUrl;
    }

    public MutableUrl addQueryParameter(UrlParameter queryParameter) {
        if (this.mQueryParameters == null) {
            this.mQueryParameters = new UrlParameters();
        }
        this.mQueryParameters.addParameters(queryParameter);
        return this;
    }

    private String getQueryParams() {
        if (this.mQueryParameters == null || this.mQueryParameters.isEmpty()) {
            return "";
        }
        return "?" + this.mQueryParameters.getString(true);
    }

    public String getUrl() {
        return String.format(STRUCTURE, this.getBaseUrlWithParams(), this.getQueryParams());
    }
}

