/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.js;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewTreeObserver;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import com.taboola.android.OnScrollChangedListenerImpl;
import com.taboola.android.Taboola;
import com.taboola.android.api.TaboolaOnClickListener;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.integration_verifier.IntegrationVerifier;
import com.taboola.android.js.InjectedObject;
import com.taboola.android.js.JsInitDataObserver;
import com.taboola.android.js.OnRenderListener;
import com.taboola.android.js.OnResizeListener;
import com.taboola.android.js.TaboolaJs;
import com.taboola.android.listeners.TaboolaUpdateContentListener;
import com.taboola.android.utils.GDPRUtils;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.SdkDetailsHelper;
import com.taboola.android.utils.VisibilityUtil;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

class WebViewManager
implements ViewTreeObserver.OnScrollChangedListener {
    private static final String TAG = WebViewManager.class.getSimpleName();
    private static final long SCROLL_EVENT_DELAY_MS = 500L;
    private static final String NOTIFY_EXTERNAL_RECTS = "notifyExternalRects";
    private static final String HIGHTLIGHT_PLACEMENT = "highlightPlacement";
    private static final String WEBVIEW_REGISTERED = "webviewRegistered";
    private static final String EDIT_PROPERTIES = "editProperties";
    private static final String UPDATE_PASSED_ACTION = "updateAction";
    private static final String UPDATE_CONTENT = "updateContent";
    private WebView mWebView;
    private Handler mMainHandler = new Handler(Looper.getMainLooper());
    private Runnable mNotifyOnScrollRunnable;
    private OnScrollChangedListenerImpl mScrollChangedListenerImpl;
    private HashMap<String, String> mPlacementIdMap = new HashMap();
    private Messenger mWebViewMessenger;
    private OnRenderListener mOnRenderListener;
    private OnResizeListener mOnResizeListener;
    private TaboolaOnClickListener mTaboolaOnClickListener;
    private boolean mIsAlive;
    private boolean mDidCollectEvents;
    private long mLastScrollEventSentTimestamp = 0L;
    private Boolean mShouldAllowNonOrganicClickOverride = null;
    private boolean mIsUsedInTaboolaWidget = false;
    private String mMediatedVia;
    private Map<String, String> mExtraData;
    private Map<String, String> mEventCollector;
    private boolean didRender;
    private String mTag;
    private InjectedObject injectedObject;
    private JSONObject mNativeWindowRect;
    private boolean mEnableHorizontalScroll;
    private NetworkManager mNetworkManager;
    private String mConfigurationJsonString;
    private TaboolaUpdateContentListener mTaboolaUpdateContentListener;

    WebViewManager(WebView webView, NetworkManager networkManager) {
        this.mWebView = webView;
        this.mNetworkManager = networkManager;
        this.mWebView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                if (left == 0 && top == 0 && right == 0 && bottom == 0) {
                    return;
                }
                WebViewManager.this.notifyExternalRects();
            }
        });
        this.mNotifyOnScrollRunnable = new Runnable(){

            @Override
            public void run() {
                if (WebViewManager.this.mWebView != null) {
                    WebViewManager.this.notifyExternalRects();
                }
            }
        };
        if (this.isSdkMonitorEnabled()) {
            this.mMainHandler.post(new Runnable(){

                @Override
                public void run() {
                    WebViewManager.this.mWebViewMessenger = new Messenger((Handler)new JsMonitorHandler(WebViewManager.this));
                }
            });
        }
    }

    void registerWebView() {
        Context context = this.mWebView.getContext();
        if (context == null) {
            Logger.e(TAG, "registerWebView, WebView is not attached ", new Exception());
            return;
        }
        this.injectedObject = new InjectedObject(context, this, this.mNetworkManager);
        this.mWebView.addJavascriptInterface((Object)this.injectedObject, "taboolaNative");
        TaboolaJs.getInstance().getAdvertisingId(new TaboolaJs.AdvertisingIdRetrievedCallback(){

            @Override
            public void onAdIdRetrieved(String id) {
                if (WebViewManager.this.mWebView != null) {
                    WebViewManager.this.onAdIdRetrieved();
                }
            }
        }, context.getApplicationContext());
    }

    void fetchContent() {
        Context context = this.mWebView.getContext();
        if (context == null) {
            Logger.e(TAG, "fetchContent, WebView is not attached ", new Exception());
            return;
        }
        this.emitTaboolaBridgeEvent("fetchRbox", null);
    }

    private void onAdIdRetrieved() {
        this.initScrollChangeListener();
        this.mIsAlive = true;
        this.emitTaboolaBridgeEvent(WEBVIEW_REGISTERED, null);
    }

    private void initScrollChangeListener() {
        if (this.mScrollChangedListenerImpl == null) {
            this.mScrollChangedListenerImpl = new OnScrollChangedListenerImpl((View)this.mWebView);
            this.mScrollChangedListenerImpl.addListener(this);
        }
    }

    void unregisterWebView() {
        this.mIsAlive = false;
        if (this.mScrollChangedListenerImpl != null) {
            this.mScrollChangedListenerImpl.clear();
            this.mScrollChangedListenerImpl = null;
        }
        if (this.mMainHandler != null) {
            this.mMainHandler.removeCallbacksAndMessages(null);
        }
        this.mWebView.removeJavascriptInterface("taboolaNative");
        if (this.injectedObject != null) {
            this.injectedObject.clearDependencies();
            this.injectedObject = null;
        }
        this.mNotifyOnScrollRunnable = null;
        this.mOnResizeListener = null;
        this.mOnRenderListener = null;
        this.mWebView = null;
    }

    void setDidRender(boolean didRender) {
        this.didRender = didRender;
    }

    public void onScrollChanged() {
        long currentTimeMillis = System.currentTimeMillis();
        if (this.mLastScrollEventSentTimestamp + 500L < currentTimeMillis) {
            this.notifyExternalRects();
            this.mLastScrollEventSentTimestamp = currentTimeMillis;
            this.mMainHandler.removeCallbacks(this.mNotifyOnScrollRunnable);
            this.mMainHandler.postDelayed(this.mNotifyOnScrollRunnable, 500L);
        }
    }

    private void notifyExternalRects() {
        if (this.mWebView != null && this.didRender) {
            this.emitTaboolaBridgeEvent(NOTIFY_EXTERNAL_RECTS, this.getVisibleBounds());
        }
    }

    void emitTaboolaBridgeEvent(String eventName, String eventData) {
        if (!this.mDidCollectEvents) {
            if (this.mEventCollector == null) {
                this.mEventCollector = new HashMap<String, String>();
            }
            this.mEventCollector.put(eventName, eventData);
            return;
        }
        StringBuilder parameters = new StringBuilder();
        parameters.append("taboolaBridge.emit('").append(eventName).append("'");
        if (eventData != null) {
            parameters.append(",").append(eventData);
        }
        parameters.append(")");
        this.callJsFunction(parameters.toString());
    }

    void callJsFunction(String func) {
        if (this.mWebView != null) {
            if (Build.VERSION.SDK_INT >= 19) {
                this.mWebView.evaluateJavascript(func, null);
            } else {
                this.mWebView.loadUrl("javascript:" + func);
            }
        }
    }

    String getDeviceData() {
        final JSONObject deviceData = new JSONObject();
        JSONObject additionalData = SdkDetailsHelper.createSdkDetailsJSON(this.mWebView.getContext(), this.mMediatedVia, this.getSdkType());
        String advertisingId = TaboolaJs.getInstance().getAdvertisingIdFromMemory();
        try {
            deviceData.put("verifier_enabled", IntegrationVerifier.isEnabled());
            deviceData.put("additional_data", (Object)additionalData);
            deviceData.put("device", (Object)(TextUtils.isEmpty((CharSequence)advertisingId) ? "undefined" : advertisingId));
            if (this.mExtraData != null) {
                for (Map.Entry<String, String> entry : this.mExtraData.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    deviceData.put(key, (Object)value);
                }
            }
            this.mConfigurationJsonString = Taboola.getTaboolaImpl().loadAndGetConfigManager().getConfigurationAsJsonString();
            deviceData.put("taboolaConfig", (Object)this.mConfigurationJsonString);
            this.addGdprInfo(deviceData);
            this.addHorizontalFlag(deviceData);
        }
        catch (JSONException e) {
            Logger.e(TAG, "getDeviceData: fail " + e.toString(), e);
            e.printStackTrace();
        }
        if (this.isSdkMonitorEnabled()) {
            this.mMainHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    WebViewManager.this.reportToMonitor(deviceData);
                }
            }, 1000L);
        }
        return deviceData.toString();
    }

    void collectPendingEvents() {
        this.mDidCollectEvents = true;
        if (this.mEventCollector != null) {
            for (Map.Entry<String, String> entry : this.mEventCollector.entrySet()) {
                this.emitTaboolaBridgeEvent(entry.getKey(), entry.getValue());
            }
        }
        this.mEventCollector = null;
    }

    private void reportToMonitor(final JSONObject deviceData) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.getWebView().evaluateJavascript("(function() { return MOBILE_LOADER_VERSION; })();", (ValueCallback)new ValueCallback<String>(){

                public void onReceiveValue(String value) {
                    try {
                        deviceData.put("mobileLoaderVersion", (Object)(TextUtils.isEmpty((CharSequence)value) ? "undefined" : value));
                        TaboolaJs.getInstance().reportDeviceDataToMonitor(deviceData.toString());
                    }
                    catch (Exception e) {
                        Logger.e(TAG, e.toString(), e);
                    }
                }
            });
        } else {
            TaboolaJs.getInstance().reportDeviceDataToMonitor(deviceData.toString());
        }
    }

    String getSdkType() {
        if (this.mIsUsedInTaboolaWidget) {
            return "Taboola Android SDK";
        }
        return "Taboola Android SDK - JS";
    }

    String getVisibleBounds() {
        JSONObject mJsonRects = new JSONObject();
        try {
            mJsonRects.put("webViewRect", (Object)VisibilityUtil.getViewJsonRect((View)this.mWebView));
            if (this.mNativeWindowRect == null) {
                this.mNativeWindowRect = VisibilityUtil.getScreenJsonRect();
            }
            mJsonRects.put("nativeWindowRect", (Object)this.mNativeWindowRect);
        }
        catch (JSONException e) {
            Logger.e(TAG, "getVisibleBounds :: " + e.toString());
        }
        return mJsonRects.toString();
    }

    private String getPlacementId(String placementName) {
        String placementId = this.mPlacementIdMap.get(placementName);
        if (placementId == null) {
            placementId = UUID.randomUUID().toString();
            this.mPlacementIdMap.put(placementName, placementId);
        }
        return placementId;
    }

    void setExtraProperties(Map<String, String> extraProperties) {
        this.mIsUsedInTaboolaWidget = this.getBooleanOrDefault(extraProperties, "isUsedInTaboolaWidget", this.mIsUsedInTaboolaWidget);
        this.mEnableHorizontalScroll = this.getBooleanOrDefault(extraProperties, "enableHorizontalScroll", this.mEnableHorizontalScroll);
        extraProperties.remove("enableHorizontalScroll");
        if (this.mIsUsedInTaboolaWidget) {
            this.mMediatedVia = extraProperties.get("mediatedVia");
        }
        this.mShouldAllowNonOrganicClickOverride = this.getBooleanOrDefault(extraProperties, "allowNonOrganicClickOverride", this.mShouldAllowNonOrganicClickOverride != null && this.mShouldAllowNonOrganicClickOverride != false);
        if (this.mExtraData != null) {
            this.mExtraData.putAll(extraProperties);
        } else {
            this.mExtraData = extraProperties;
        }
    }

    boolean getBooleanOrDefault(Map<String, String> map, String key, boolean defaultValue) {
        String value = map.get(key);
        if (TextUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    boolean isAlive() {
        return this.mIsAlive;
    }

    WebView getWebView() {
        return this.mWebView;
    }

    OnRenderListener getOnRenderListener() {
        return this.mOnRenderListener;
    }

    void setOnRenderListener(@Nullable OnRenderListener onRenderListener) {
        this.mOnRenderListener = onRenderListener;
    }

    OnResizeListener getOnResizeListener() {
        return this.mOnResizeListener;
    }

    void setOnResizeListener(@Nullable OnResizeListener onResizeListener) {
        this.mOnResizeListener = onResizeListener;
    }

    public void setOnClickListener(TaboolaOnClickListener onClickListener) {
        this.mTaboolaOnClickListener = onClickListener;
    }

    public TaboolaOnClickListener getOnClickListener() {
        return this.mTaboolaOnClickListener;
    }

    Boolean shouldAllowNonOrganicClickOverride() {
        return this.mShouldAllowNonOrganicClickOverride;
    }

    boolean isSdkMonitorEnabled() {
        return TaboolaJs.getInstance().isSdkMonitorEnabled();
    }

    void sendRenderSuccessful(final String placementName) {
        final String placementId = this.getPlacementId(placementName);
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                TaboolaJs.getInstance().getSdkMonitorManager().sendWebPlacementRenderSuccess(placementId, WebViewManager.this.getSdkType(), placementName, WebViewManager.this.mWebViewMessenger);
            }
        });
    }

    public void prepareAndSendParamsToMonitor(String placementName, HashMap<String, String> parameters) {
        if (this.isSdkMonitorEnabled()) {
            String placementId = this.getPlacementId(placementName);
            TaboolaJs.getInstance().sendWebPlacementFetchContent(placementId, this.getSdkType(), placementName, parameters);
        }
    }

    void sendRenderFailed(final String placementName) {
        final String placementId = this.getPlacementId(placementName);
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                TaboolaJs.getInstance().getSdkMonitorManager().sendWebPlacementRenderFailed(placementId, WebViewManager.this.getSdkType(), placementName, WebViewManager.this.mWebViewMessenger);
            }
        });
    }

    void sendMonitorData(String placementName, final String data, final String html) {
        final String placementId = this.mPlacementIdMap.get(placementName);
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                TaboolaJs.getInstance().getSdkMonitorManager().sendWebPlacementMonitorData(placementId, data, html);
            }
        });
    }

    void sendPlacementClicked(String placementName) {
        final String placementId = this.getPlacementId(placementName);
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                TaboolaJs.getInstance().getSdkMonitorManager().sendWebPlacementClicked(placementId);
            }
        });
    }

    public void setTag(String tag) {
        this.mTag = tag;
    }

    public String getTag() {
        return this.mTag;
    }

    void showProgressBar() {
        this.callJsFunction("taboolaProgressBarShow()");
    }

    void scrollToTop() {
        this.callJsFunction("document.body.scrollTop = 0;");
    }

    public void notifyUpdateHeight() {
        this.emitTaboolaBridgeEvent("onAttachedToWindow", null);
    }

    public void addJsInitDataObserver(JsInitDataObserver jsDataObserver) {
        if (this.injectedObject != null) {
            this.injectedObject.addJsInitDataObserver(jsDataObserver);
        }
    }

    public void reportUserAction(final int actionType, final String dataJsonString) {
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                TaboolaJs.getInstance().reportUserAction(actionType, dataJsonString);
            }
        });
    }

    private void addGdprInfo(JSONObject deviceData) throws JSONException {
        boolean cmpPresentValue;
        if (this.mWebView != null && (cmpPresentValue = GDPRUtils.getCmpPresentValue(this.mWebView.getContext().getApplicationContext()))) {
            JSONObject gdprJsonObject = new JSONObject();
            gdprJsonObject.put("cmpStatus", (Object)"0");
            gdprJsonObject.put("gdprApplies", (Object)GDPRUtils.getSubjectToGdpr(this.mWebView.getContext().getApplicationContext()));
            gdprJsonObject.put("consentData", (Object)GDPRUtils.getConsentString(this.mWebView.getContext().getApplicationContext()));
            deviceData.put("gdpr", (Object)gdprJsonObject);
        }
    }

    private void addHorizontalFlag(JSONObject deviceData) throws JSONException {
        if (this.mWebView != null && this.mIsUsedInTaboolaWidget && this.mEnableHorizontalScroll) {
            deviceData.put("enableHorizontalScroll", true);
        }
    }

    public void updatePassedAction(int actionType, String actionString) {
        JSONObject passedObject = new JSONObject();
        try {
            passedObject.put("action", actionType);
            passedObject.put("data", (Object)actionString);
            this.emitTaboolaBridgeEvent(UPDATE_PASSED_ACTION, passedObject.toString());
        }
        catch (JSONException e) {
            Logger.e(TAG, "UpdatePassedAction : " + e.getMessage());
        }
    }

    void updateContent() {
        this.emitTaboolaBridgeEvent(UPDATE_CONTENT, null);
    }

    void updateContentCompleted() {
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                TaboolaJs.getInstance().updateContentCompleted(WebViewManager.this);
            }
        });
    }

    public void setOnUpdateContentListener(TaboolaUpdateContentListener updateContentListener) {
        this.mTaboolaUpdateContentListener = updateContentListener;
    }

    public TaboolaUpdateContentListener getOnUpdateContentListener() {
        return this.mTaboolaUpdateContentListener;
    }

    private static class JsMonitorHandler
    extends Handler {
        private final WeakReference<WebViewManager> mWebViewManagerWeakReference;

        JsMonitorHandler(WebViewManager webViewManager) {
            this.mWebViewManagerWeakReference = new WeakReference<WebViewManager>(webViewManager);
        }

        public void handleMessage(Message msg) {
            WebViewManager webViewManager = (WebViewManager)this.mWebViewManagerWeakReference.get();
            if (webViewManager != null) {
                switch (msg.what) {
                    case 291: {
                        String placementName = msg.getData().getString("PLACEMENT_NAME_BUNDLE_KEY");
                        webViewManager.emitTaboolaBridgeEvent(WebViewManager.HIGHTLIGHT_PLACEMENT, placementName);
                        break;
                    }
                    case 231: {
                        String placementName = msg.getData().getString("PLACEMENT_NAME_BUNDLE_KEY");
                        String newProperties = msg.getData().getString("WEB_NEW_PROPERTIES_JSON_BUNDLE_KEY");
                        StringBuilder editProp = new StringBuilder();
                        editProp.append(placementName).append(",").append(newProperties);
                        webViewManager.emitTaboolaBridgeEvent(WebViewManager.EDIT_PROPERTIES, editProp.toString());
                        break;
                    }
                }
            }
        }
    }
}

