/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.api;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Messenger;
import android.support.annotation.Keep;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.taboola.android.MonitorManager;
import com.taboola.android.Taboola;
import com.taboola.android.api.TBImageErrorListener;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBPlacementRequest;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.api.TBRecommendationRequestCallback;
import com.taboola.android.api.TBRecommendationsRequest;
import com.taboola.android.api.TBRecommendationsResponse;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.api.TaboolaOnClickListener;
import com.taboola.android.api.TestHelperInternal;
import com.taboola.android.api.TypeAdapterTBRecommendationResponse;
import com.taboola.android.global_components.configuration.ConfigManager;
import com.taboola.android.global_components.configuration.PropertyResolver;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.global_components.network.dynamic_apis.RecommendationsAPI;
import com.taboola.android.integration_verifier.IntegrationVerifier;
import com.taboola.android.integration_verifier.requests.VerificationRequest;
import com.taboola.android.integration_verifier.testing.TestIDs;
import com.taboola.android.integration_verifier.testing.tests.publisher_config.PublisherConfigParams_API;
import com.taboola.android.monitor.TBUrlParamsChange;
import com.taboola.android.utils.AdvertisingIdClient;
import com.taboola.android.utils.ExtraProperty;
import com.taboola.android.utils.GDPRUtils;
import com.taboola.android.utils.IntegrationVerifierUtils;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.MonitorUtils;
import com.taboola.android.utils.OnClickHelper;
import com.taboola.android.utils.PopupHelper;
import com.taboola.android.utils.SdkDetailsHelper;
import com.taboola.android.utils.SecurityUtils;
import com.taboola.android.utils.SharedPrefUtil;
import com.taboola.lightnetwork.dynamic_url.DynamicRequest;
import com.taboola.lightnetwork.protocols.http.HttpError;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import com.taboola.lightnetwork.protocols.http.HttpResponse;
import java.io.Serializable;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.UUID;
import org.json.JSONObject;

@Keep
public class TBPublisherApi {
    private static final String TAG = "TBPublisherApi";
    private static final String REQUEST_ID_KEY = "req_id";
    private static final String PUBLISHER_ID = "PublisherId";
    private static final String API_KEY = "apiKey";
    private static final String ADDITIONAL_DATA = "additional_data";
    private static final String TIMESTAMP = "timestamp";
    private static final String EVENT = "event";
    private static final String SHOULD_ALLOW_NON_ORGANIC_CLICK_OVERRIDE = "mShouldAllowNonOrganicClickOverride";
    private static final String IS_ENABLED_RAW_DATA_RESPONSE = "mIsEnabledRawDataResponse";
    private static final String USE_HTTP = "mUseHttp";
    private static final String API_PARAMS = "mApiParams";
    private static final String MOBILE_INIT = "mobileInit";
    private static final String RESPONSE_ID = "response.id";
    private static final String RESPONSE_SESSION = "response.session";
    private static final String APP_TYPE = "app.type";
    private static final String MOBILE = "mobile";
    private static final String APP_APIKEY = "app.apikey";
    private static final String ITEM_TYPE = "item.type";
    private static final String ITEM_ID = "item.id";
    private static final String DEVICE = "device";
    private static final String EVENT_DATA = "event.data";
    public static final String TABOOLA_HOST = "taboola.com";
    public static final String PIXEL_EVENT_AVAILABLE = "i";
    public static final String PIXEL_EVENT_VISIBLE = "vi";
    public static final String PIXEL_EVENT_CLICK = "c";
    private final Object mUserSessionLock = new Object();
    private IntegrationVerifier integrationVerifier;
    private int onClickIgnoreTimeMs = 300;
    private static final String BASE_URL = "://api.taboola.com/1.2/json/";
    private static final String HTTP_PREFIX = "http";
    private static final String HTTPS_PREFIX = "https";
    @Nullable
    private String mAdvertisingId = null;
    private String mPublisherId;
    private String apiKey;
    private boolean mShouldAllowNonOrganicClickOverride = false;
    private boolean mIsEnabledRawDataResponse = false;
    private boolean mIsEnabledFullRawDataResponse = false;
    private boolean mUseHttp = false;
    private Map<String, String> mApiParams;
    private Handler mVisibilityMonitoringHandler = new Handler(Looper.getMainLooper());
    private Map<String, TBRecommendationsRequest> mRequestMap = new HashMap<String, TBRecommendationsRequest>();
    private Drawable mImagePlaceholderDrawable;
    private TaboolaOnClickListener mOnClickListener;
    private TestHelperInternal.SdkEventsTestListener mSdkEventsTestListener;
    private RecommendationsAPI mRecommendationsAPI;
    private SimpleDateFormat mDefaultSdf;
    private SimpleDateFormat mReportEventDateFormat;
    private Handler mUiHandler;
    private TaboolaApi mTaboolaApi;
    private Gson mGson;
    private boolean mOverrideImageLoad;
    private String mForceClickOnPackage;
    private String mOverrideBaseUrl;
    private NetworkManager mNetworkManager;
    private ConfigManager mConfigManager;

    TBPublisherApi(NetworkManager networkManager, ConfigManager configManager) {
        this.mNetworkManager = networkManager;
        this.mConfigManager = configManager;
        this.createDataFormat();
        if (IntegrationVerifier.isEnabled()) {
            this.integrationVerifier = Taboola.getTaboolaImpl().getIntegrationVerifier();
        }
    }

    private void createDataFormat() {
        this.mDefaultSdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault());
        this.mDefaultSdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.mReportEventDateFormat = new SimpleDateFormat("HH:mm:ss.SSS", Locale.getDefault());
        this.mReportEventDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    TBPublisherApi(NetworkManager networkManager, ConfigManager configManager, String publisherId) {
        this(networkManager, configManager);
        this.mPublisherId = publisherId;
    }

    @MainThread
    public TBPublisherApi init(Context applicationContext, String apiKey) {
        return this.init(applicationContext, this.mPublisherId, apiKey, null);
    }

    @MainThread
    public TBPublisherApi init(Context applicationContext, String apiKey, Map<String, String> extraProperties) {
        return this.init(applicationContext, this.mPublisherId, apiKey, extraProperties);
    }

    @MainThread
    TBPublisherApi init(Context ctx, String publisherId, String apiKey, Map<String, String> extraProperties) {
        Context applicationContext = ctx.getApplicationContext();
        this.mTaboolaApi = TaboolaApi.getInstance();
        this.mTaboolaApi.updateApplicationContext(applicationContext);
        this.initializeFeatures();
        this.setExtraProperties(extraProperties);
        if (!this.isOverrideImageLoad()) {
            this.mTaboolaApi.createPicasso(applicationContext);
        }
        this.mPublisherId = publisherId;
        this.apiKey = apiKey;
        if (this.mAdvertisingId == null) {
            AdvertisingIdClient.updateCachedAdvertisingIdAsync(applicationContext);
        }
        this.reInitNetworkClient();
        if (MonitorUtils.isSdkMonitorInstalled(applicationContext)) {
            if (this.mUiHandler == null) {
                this.mUiHandler = new Handler(Looper.getMainLooper());
            }
            this.mTaboolaApi.initSdkMonitor(applicationContext);
        }
        if (IntegrationVerifier.isEnabled()) {
            this.initVerifier(applicationContext, publisherId);
        }
        return this;
    }

    private void initializeFeatures() {
        this.mShouldAllowNonOrganicClickOverride = this.mConfigManager.getConfigValue("allowNonOrganicClickOverride", this.mShouldAllowNonOrganicClickOverride);
        this.mIsEnabledRawDataResponse = this.mConfigManager.getConfigValue("enabledRawDataResponse", this.mIsEnabledRawDataResponse);
        this.mUseHttp = this.mConfigManager.getConfigValue("useHttp", this.mUseHttp);
        this.mForceClickOnPackage = this.mConfigManager.getConfigValue(PropertyResolver.resolve(ExtraProperty.FEATURE_FORCE_CLICK_ON_APP), this.mForceClickOnPackage);
        this.mOverrideImageLoad = this.mConfigManager.getConfigValue(PropertyResolver.resolve(ExtraProperty.OVERRIDE_IMAGE_LOAD), this.mOverrideImageLoad);
        this.setAndValidateBaseUrl(this.mConfigManager.getConfigValue(PropertyResolver.resolve(ExtraProperty.HOST_NAME), this.mOverrideBaseUrl));
    }

    void updateCurrentPublisher(Map<String, String> extraProperties) {
        if (this.mTaboolaApi == null) {
            this.mTaboolaApi = TaboolaApi.getInstance();
        }
        this.setExtraProperties(extraProperties);
    }

    private void initVerifier(Context applicationContext, String publisherId) {
        IntegrationVerifier integrationVerifier = Taboola.getTaboolaImpl().getIntegrationVerifier();
        integrationVerifier.getSessionData().setPublisherId(publisherId);
        Bundle integrationVerifierBundle = new Bundle();
        integrationVerifierBundle.putString("Sdk_version_verification_key", "2.3.5-48814-4");
        integrationVerifierBundle.putInt("integration_verifier_key_integrationType", 3);
        integrationVerifierBundle.putStringArrayList("permissionsVerification_key_permissions_list", (ArrayList)new ArrayList<String>(){
            {
                this.add("android.permission.INTERNET");
                this.add("android.permission.ACCESS_NETWORK_STATE");
            }
        });
        integrationVerifier.verify(new VerificationRequest(applicationContext, integrationVerifierBundle, new TestIDs(9, 2, 3, 4, 5)));
    }

    public boolean isInitialized() {
        return this.mRecommendationsAPI != null && !TextUtils.isEmpty((CharSequence)this.mPublisherId) && this.getAppContext() != null;
    }

    private void checkIsInitialize() {
        if (this.getAppContext() == null || TextUtils.isEmpty((CharSequence)this.mPublisherId)) {
            Log.e((String)TAG, (String)"TaboolaApi is not properly initialized, did you forget to call init() ?", (Throwable)new Exception());
        }
    }

    private String getBaseUrl(String publisherId) {
        StringBuilder sb = TextUtils.isEmpty((CharSequence)this.mOverrideBaseUrl) ? new StringBuilder(this.getUrlProtocol()).append(BASE_URL) : new StringBuilder(this.mOverrideBaseUrl);
        return sb.append(publisherId).append("/").toString();
    }

    private String getUrlProtocol() {
        return this.mUseHttp ? HTTP_PREFIX : HTTPS_PREFIX;
    }

    public void fetchRecommendations(TBRecommendationsRequest request, TBRecommendationRequestCallback callback) {
        Random rand = new Random();
        int ran = rand.nextInt(100);
        if (ran <= 5) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    TBPublisherApi.this.sendBridgeToKibana();
                }
            });
            thread.start();
        }
        this.checkIsInitialize();
        Context appCtx = this.getAppContext();
        if (appCtx == null) {
            return;
        }
        if (IntegrationVerifier.isEnabled()) {
            this.verifyRecommendationsRequest(request);
        }
        request.setUserSession(this.getUserSession());
        request.setAppType(MOBILE);
        request.setApiKey(this.apiKey);
        this.addGdprInfo(request);
        request.setAppName(SdkDetailsHelper.getApplicationName(appCtx));
        if (TextUtils.isEmpty((CharSequence)request.getViewId())) {
            request.setViewId(String.valueOf(System.currentTimeMillis()));
        }
        String additionalData = SdkDetailsHelper.createSdkJsonString(appCtx, null, "Taboola Android SDK - API");
        request.setAdditionalData(additionalData);
        if (this.mApiParams != null) {
            for (String key : this.mApiParams.keySet()) {
                request.setApiParam(key, this.mApiParams.get(key));
            }
        }
        this.waitForAdvertisingIdAndFetchRecommendations(request, callback, appCtx);
    }

    private void verifyRecommendationsRequest(TBRecommendationsRequest request) {
        HashMap<String, TBPlacementRequest> placementReqeusts = request.getPlacementRequests();
        this.integrationVerifier.getSessionData().setPublisherId(this.getPublisherId());
        this.integrationVerifier.getTestsManager().getMethodCallOrderTracker().rememberNonInitApiMethodCall(3, "fetchRecommendations");
        Bundle recommendationRequestBundle = new Bundle();
        recommendationRequestBundle.putInt("integration_verifier_key_integrationType", 3);
        recommendationRequestBundle.putInt("sensiblePlacementNumber_numberOfSetPlacements", placementReqeusts.size());
        this.integrationVerifier.verify(new VerificationRequest(recommendationRequestBundle, new TestIDs(10)));
        for (TBPlacementRequest tbPlacementRequest : placementReqeusts.values()) {
            Bundle configParamsBundle = new Bundle();
            configParamsBundle.putSerializable("publisherConfigurationTest_key_configuration_params", (Serializable)new PublisherConfigParams_API(this.getPublisherId(), this.getApiKey(), tbPlacementRequest.getName(), tbPlacementRequest.getRecCount(), request.getSourceType()));
            configParamsBundle.putInt("integration_verifier_key_integrationType", 3);
            this.integrationVerifier.verify(new VerificationRequest(configParamsBundle, new TestIDs(6, 7)));
        }
        Bundle crawlUrlBundle = new Bundle();
        crawlUrlBundle.putSerializable("crawlingUrlTest_key_crawling_url", (Serializable)((Object)request.getSourceUrl()));
        crawlUrlBundle.putInt("integration_verifier_key_integrationType", 3);
        this.integrationVerifier.verify(new VerificationRequest(this.getAppContext(), crawlUrlBundle, new TestIDs(8)));
    }

    public void getNextBatchForPlacement(TBPlacement placement, TBRecommendationRequestCallback callback) {
        this.getNextBatchForPlacement(placement, 0, callback);
    }

    public void getNextBatchForPlacement(TBPlacement placement, int count, TBRecommendationRequestCallback callback) {
        this.checkIsInitialize();
        if (IntegrationVerifier.isEnabled()) {
            this.integrationVerifier.getTestsManager().getMethodCallOrderTracker().rememberNonInitApiMethodCall(3, "getNextBatchForPlacement");
        }
        TBRecommendationsRequest nextBatchRequest = placement.getNextBatchRequest();
        nextBatchRequest.setUserSession(this.getUserSession());
        if (count > 0) {
            TBPlacementRequest placementRequest = nextBatchRequest.getPlacementRequests().values().iterator().next();
            placementRequest.setRecCount(count);
        }
        this.actuallyFetchRecommendations(nextBatchRequest, callback);
    }

    public void handleAttributionClick(@NonNull Context context) {
        if (context == null) {
            Logger.e(TAG, "Attribution dialog can't be showed, Context is missing");
            return;
        }
        String locale = context.getResources().getConfiguration().locale.getCountry();
        String url = "https://popup.taboola.com/" + locale;
        boolean isHandled = false;
        if (context instanceof Activity) {
            isHandled = PopupHelper.openPopup(context, url);
        }
        if (!isHandled) {
            Logger.d(TAG, "can't to open as popup, so opening in browser");
            this.openUrlInTabsOrBrowser(context, url);
        }
    }

    private void openUrlInTabsOrBrowser(Context context, String url) {
        if (!TextUtils.isEmpty((CharSequence)this.mForceClickOnPackage)) {
            OnClickHelper.openUrlInApp(context, url, this.mForceClickOnPackage);
        } else {
            OnClickHelper.openUrlInTabsOrBrowser(context, url);
        }
    }

    public TBPublisherApi setOnClickListener(TaboolaOnClickListener onClickListener) {
        this.checkIsInitialize();
        this.mOnClickListener = onClickListener;
        return this;
    }

    public TBPublisherApi setOnClickIgnoreTimeMs(int onClickIgnoreTimeMs) {
        this.checkIsInitialize();
        this.onClickIgnoreTimeMs = onClickIgnoreTimeMs;
        return this;
    }

    public TBPublisherApi setLogLevel(int logLevel) {
        this.checkIsInitialize();
        Logger.setLogLevel(this.isSdkMonitorEnabled() ? 3 : logLevel);
        return this;
    }

    public TBPublisherApi setImagePlaceholder(Drawable placeholderDrawable) {
        this.checkIsInitialize();
        this.mImagePlaceholderDrawable = placeholderDrawable;
        return this;
    }

    public TBPublisherApi setExtraProperties(Map<String, String> extraProperties) {
        IntegrationVerifierUtils.verifyExtraProperties(this.integrationVerifier, 3, extraProperties);
        if (extraProperties == null || extraProperties.isEmpty()) {
            return this;
        }
        this.checkIsInitialize();
        for (String key : extraProperties.keySet()) {
            String value = extraProperties.get(key);
            ExtraProperty extraProperty = ExtraProperty.getExtraProperty(key);
            switch (extraProperty) {
                case UNRECOGNIZABLE: {
                    Logger.e(TAG, "setExtraProperties got unrecognized property. key = " + key);
                    break;
                }
                case ENABLE_RAW_PROP_FULL: {
                    this.mIsEnabledFullRawDataResponse = this.mConfigManager.getConfigValue(key, Boolean.parseBoolean(value));
                    break;
                }
                case ENABLE_RAW_DATA_PROP: {
                    this.mIsEnabledRawDataResponse = this.mConfigManager.getConfigValue(key, Boolean.parseBoolean(value));
                    break;
                }
                case ALLOW_NON_ORGANIC_OVERRIDE_PROP: {
                    this.mShouldAllowNonOrganicClickOverride = this.mConfigManager.getConfigValue(key, Boolean.parseBoolean(value));
                    break;
                }
                case USE_HTTP_PROP: {
                    this.mUseHttp = this.mConfigManager.getConfigValue(key, Boolean.parseBoolean(value));
                    break;
                }
                case API_PARAMS: {
                    String apiParamsFromConfigManager = this.mConfigManager.getConfigValue(key, value);
                    Map<String, String> apiParamMapFromConfig = this.getApiParams(apiParamsFromConfigManager);
                    this.mApiParams = this.getApiParams(value);
                    this.mApiParams.putAll(apiParamMapFromConfig);
                    break;
                }
                case OVERRIDE_IMAGE_LOAD: {
                    this.mOverrideImageLoad = this.mConfigManager.getConfigValue(key, Boolean.parseBoolean(value));
                    break;
                }
                case FEATURE_FORCE_CLICK_ON_APP: {
                    this.mForceClickOnPackage = this.mConfigManager.getConfigValue(key, value);
                    break;
                }
                case HOST_NAME: {
                    this.setAndValidateBaseUrl(this.mConfigManager.getConfigValue(key, value));
                }
            }
        }
        return this;
    }

    private void setAndValidateBaseUrl(String hostname) {
        if (!TextUtils.equals((CharSequence)hostname, (CharSequence)this.mOverrideBaseUrl)) {
            try {
                URI uri = new URI(hostname);
                String host = uri.getHost();
                this.mOverrideBaseUrl = host.endsWith(TABOOLA_HOST) ? hostname : null;
                this.reInitNetworkClient();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.toString());
                this.mOverrideBaseUrl = null;
            }
        }
    }

    private void reInitNetworkClient() {
        if (!TextUtils.isEmpty((CharSequence)this.mPublisherId)) {
            this.mRecommendationsAPI = new RecommendationsAPI(this.mNetworkManager, this.getBaseUrl(this.mPublisherId));
        }
    }

    private Map<String, String> getApiParams(String params) {
        try {
            String[] separated;
            HashMap<String, String> map = new HashMap<String, String>();
            for (String param : separated = params.split(",")) {
                String[] keyV = param.split("=");
                if (keyV.length == 0) continue;
                if (keyV.length == 1) {
                    Log.w((String)TAG, (String)("getApiParams: key: " + keyV[0] + " has an empty value"));
                    map.put(keyV[0].trim(), "");
                    continue;
                }
                if (!TextUtils.isEmpty((CharSequence)keyV[0])) {
                    map.put(keyV[0].trim(), keyV[1]);
                    continue;
                }
                Log.w((String)TAG, (String)"getApiParams: key is missing");
            }
            return map;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"getApiParams() | invalid params");
            return new HashMap<String, String>(0);
        }
    }

    void setSdkEventsTestListener(TestHelperInternal.SdkEventsTestListener sdkEventsTestListener) {
        this.mSdkEventsTestListener = sdkEventsTestListener;
    }

    Drawable getImagePlaceholder() {
        return this.mImagePlaceholderDrawable;
    }

    void onPlacementAvailable(String responseId, TBPlacement placement) {
        if (this.mSdkEventsTestListener != null) {
            this.mSdkEventsTestListener.onAvailable();
        }
        Map<String, String> queryParameters = this.getPlacementDescriptionParams(responseId);
        if (this.mRecommendationsAPI != null) {
            DynamicRequest notifyAvailable = this.mRecommendationsAPI.notifyAvailable(queryParameters);
            final String requestUrl = notifyAvailable.getFinalUrl();
            notifyAvailable.execute(new HttpManager.NetworkResponse(){

                @Override
                public void onResponse(HttpResponse response) {
                    TBPublisherApi.this.sendUrlToMonitorIfEnabled(requestUrl);
                    Logger.d(TBPublisherApi.TAG, "onPlacementAvailable notification successfully sent");
                }

                @Override
                public void onError(HttpError error) {
                    TBPublisherApi.this.sendUrlToMonitorIfEnabled(requestUrl);
                    Logger.e(TBPublisherApi.TAG, "onPlacementAvailable notification failed " + error);
                }
            });
        }
        for (TBRecommendationItem item : placement.getItems()) {
            Map<String, List<String>> trackingPixelMap = item.getTrackingPixelMap();
            if (trackingPixelMap == null || trackingPixelMap.isEmpty()) continue;
            List<String> visibleTrackingPixelUrls = trackingPixelMap.get(PIXEL_EVENT_AVAILABLE);
            this.sendTrackingPixel(visibleTrackingPixelUrls, PIXEL_EVENT_AVAILABLE);
        }
    }

    private void sendTrackingPixel(List<String> trackingPixelUrls, final String pixelType) {
        if (trackingPixelUrls != null) {
            for (final String url : trackingPixelUrls) {
                if (TextUtils.isEmpty((CharSequence)url)) continue;
                this.mNetworkManager.getHttpManager().get(url, new HttpManager.NetworkResponse(){

                    @Override
                    public void onResponse(HttpResponse response) {
                        TBPublisherApi.this.sendUrlToMonitorIfEnabled(url);
                        Logger.d(TBPublisherApi.TAG, pixelType + " Pixel fired on: " + url);
                    }

                    @Override
                    public void onError(HttpError error) {
                        TBPublisherApi.this.sendUrlToMonitorIfEnabled(url);
                    }
                });
            }
        }
    }

    void sendUrlToMonitorIfEnabled(final String url) {
        if (this.isSdkMonitorEnabled() && this.mTaboolaApi.isShouldMonitorNetwork()) {
            this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    TBPublisherApi.this.mTaboolaApi.sendUrlToMonitor(url);
                }
            });
        }
    }

    void onPlacementVisible(String responseId, TBPlacement placement) {
        if (this.mSdkEventsTestListener != null) {
            this.mSdkEventsTestListener.onVisible();
        }
        Map<String, String> queryParameters = this.getPlacementDescriptionParams(responseId);
        if (this.mRecommendationsAPI != null) {
            DynamicRequest notifyVisibleRequest = this.mRecommendationsAPI.notifyVisible(queryParameters);
            final String requestUrl = notifyVisibleRequest.getFinalUrl();
            notifyVisibleRequest.execute(new HttpManager.NetworkResponse(){

                @Override
                public void onResponse(HttpResponse response) {
                    TBPublisherApi.this.sendUrlToMonitorIfEnabled(requestUrl);
                    Logger.d(TBPublisherApi.TAG, "onPlacementVisible notification successfully sent");
                }

                @Override
                public void onError(HttpError error) {
                    TBPublisherApi.this.sendUrlToMonitorIfEnabled(requestUrl);
                    Logger.e(TBPublisherApi.TAG, "onPlacementVisible notification failed " + error);
                }
            });
        }
        for (TBRecommendationItem item : placement.getItems()) {
            Map<String, List<String>> trackingPixelMap = item.getTrackingPixelMap();
            if (trackingPixelMap == null || trackingPixelMap.isEmpty()) continue;
            List<String> visibleTrackingPixelUrls = trackingPixelMap.get(PIXEL_EVENT_VISIBLE);
            this.sendTrackingPixel(visibleTrackingPixelUrls, PIXEL_EVENT_VISIBLE);
        }
    }

    void reportClientEvent(String type, Map<String, String> data, String password, String responseId) {
        String keyHash = SecurityUtils.md5(password).toLowerCase();
        if (!keyHash.equalsIgnoreCase("94bfc32fb5d21fdfd6147eeaf0882d7f")) {
            Logger.e(TAG, "reportEvent wrong password " + password);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)type)) {
            Logger.e(TAG, "reportEvent missing type param ");
            return;
        }
        data.put("eventType", type);
        if (this.mGson == null) {
            this.mGson = new Gson();
        }
        String dataString = this.mGson.toJson(data);
        Logger.d(TAG, "reportEvent() called with: type = [" + type + "], data = [" + dataString + "], password = [" + password + "], responseId = [" + responseId + "]");
        Map<String, String> queryParameters = this.getPlacementDescriptionParams(responseId);
        queryParameters.put(EVENT_DATA, dataString);
        if (this.mRecommendationsAPI != null) {
            DynamicRequest notifyClickEvent = this.mRecommendationsAPI.notifyClientEvent(queryParameters);
            final String requestUrl = notifyClickEvent.getFinalUrl();
            notifyClickEvent.execute(new HttpManager.NetworkResponse(){

                @Override
                public void onResponse(HttpResponse response) {
                    TBPublisherApi.this.sendUrlToMonitorIfEnabled(requestUrl);
                    Logger.e(TBPublisherApi.TAG, "reportEvent fail with unexpected code " + response);
                }

                @Override
                public void onError(HttpError error) {
                    TBPublisherApi.this.sendUrlToMonitorIfEnabled(requestUrl);
                    Logger.e(TBPublisherApi.TAG, "reportEvent failed " + error);
                }
            });
        }
    }

    void onItemClick(Context context, String placementName, final String placementId, String itemId, String clickUrl, boolean isOrganic, String itemType, List<String> clickPixelTrackingList) {
        if (this.isSdkMonitorEnabled()) {
            this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    TBPublisherApi.this.getSdkMonitorManager().sendApiClicked(placementId);
                }
            });
        }
        this.mNetworkManager.getTrackingHandler().reportPreClick(context.getApplicationContext(), this.mPublisherId, clickUrl, "Taboola Android SDK - API");
        this.sendTrackingPixel(clickPixelTrackingList, PIXEL_EVENT_CLICK);
        boolean shouldSdkHandleClick = true;
        if (this.mOnClickListener != null) {
            shouldSdkHandleClick = this.mOnClickListener.onItemClick(placementName, itemId, clickUrl, isOrganic);
        }
        if (shouldSdkHandleClick) {
            this.openUrlInTabsOrBrowser(context, clickUrl);
        } else if (isOrganic || this.mShouldAllowNonOrganicClickOverride) {
            this.notifyClick(placementId, itemType, itemId);
        } else {
            Logger.d(TAG, "onItemClick: Performing default click action even though click handler returned \u201cfalse\u201d.Can only override default click action for organic items");
            this.openUrlInTabsOrBrowser(context, clickUrl);
        }
    }

    int getOnClickIgnoreTimeMs() {
        return this.onClickIgnoreTimeMs;
    }

    Handler getVisibilityMonitoringHandler() {
        return this.mVisibilityMonitoringHandler;
    }

    boolean isEnabledRawDataResponse() {
        return this.mIsEnabledRawDataResponse;
    }

    boolean isEnabledFullRawDataResponse() {
        return this.mIsEnabledFullRawDataResponse;
    }

    boolean isOverrideImageLoad() {
        return this.mOverrideImageLoad;
    }

    private void notifyClick(String placementId, String itemType, String itemId) {
        if (this.mRecommendationsAPI != null) {
            DynamicRequest notifyClickRequest = this.mRecommendationsAPI.notifyClick(this.getNotifyClickRequestParams(placementId, itemType, itemId));
            final String requestUrl = notifyClickRequest.getFinalUrl();
            notifyClickRequest.execute(new HttpManager.NetworkResponse(){

                @Override
                public void onResponse(HttpResponse response) {
                    TBPublisherApi.this.sendUrlToMonitorIfEnabled(requestUrl);
                    Logger.d(TBPublisherApi.TAG, "onItemClick notification successfully sent");
                }

                @Override
                public void onError(HttpError error) {
                    TBPublisherApi.this.sendUrlToMonitorIfEnabled(requestUrl);
                    Logger.e(TBPublisherApi.TAG, "onItemClick notification failed " + error);
                }
            });
        }
    }

    private void waitForAdvertisingIdAndFetchRecommendations(final TBRecommendationsRequest request, final TBRecommendationRequestCallback listener, Context appCtx) {
        if (this.mAdvertisingId == null) {
            String cachedId = AdvertisingIdClient.getCachedAdvertisingId(appCtx);
            if (cachedId != null) {
                this.mAdvertisingId = cachedId;
                request.setDeviceId(this.mAdvertisingId);
                this.actuallyFetchRecommendations(request, listener);
            } else {
                AdvertisingIdClient.updateAdvertisingIdAsync(appCtx, new AdvertisingIdClient.AdvertisingIdCallback(){

                    @Override
                    public void onIdRetrieved(String advertisingId) {
                        TBPublisherApi.this.mAdvertisingId = advertisingId;
                        request.setDeviceId(TBPublisherApi.this.mAdvertisingId);
                        TBPublisherApi.this.actuallyFetchRecommendations(request, listener);
                    }

                    @Override
                    public void onIdUnavailable() {
                        TBPublisherApi.this.mAdvertisingId = "";
                        TBPublisherApi.this.actuallyFetchRecommendations(request, listener);
                    }
                });
            }
        } else if (this.mAdvertisingId.isEmpty()) {
            this.actuallyFetchRecommendations(request, listener);
        } else {
            request.setDeviceId(this.mAdvertisingId);
            this.actuallyFetchRecommendations(request, listener);
        }
    }

    private void actuallyFetchRecommendations(TBRecommendationsRequest request, final TBRecommendationRequestCallback listener) {
        if (Taboola.getTaboolaImpl().isKillSwitchEnabled(null)) {
            if (listener != null) {
                listener.onRecommendationsFailed(new Throwable("INTERNAL_1"));
            }
            Logger.e(TAG, "fetchContent | INTERNAL_1");
            return;
        }
        if (this.mRecommendationsAPI != null) {
            final String requestUuid = UUID.randomUUID().toString();
            DynamicRequest fetchRecommendationsRequest = this.mRecommendationsAPI.fetchRecomendations(this.getFetchRecommendationsParams(request, requestUuid));
            final String requestUrl = fetchRecommendationsRequest.getFinalUrl();
            fetchRecommendationsRequest.execute(new HttpManager.NetworkResponse(){

                @Override
                public void onResponse(HttpResponse response) {
                    block2: {
                        Logger.d(TBPublisherApi.TAG, "request url : " + requestUrl);
                        TBPublisherApi.this.sendUrlToMonitorIfEnabled(requestUrl);
                        try {
                            TBPublisherApi.this.onSuccessfulResponse(response.mMessage, requestUuid, listener);
                        }
                        catch (Exception e) {
                            if (listener == null) break block2;
                            listener.onRecommendationsFailed(new Throwable(e.getMessage()));
                        }
                    }
                }

                @Override
                public void onError(HttpError error) {
                    TBPublisherApi.this.sendUrlToMonitorIfEnabled(requestUrl);
                    if (listener != null) {
                        listener.onRecommendationsFailed(new Throwable(error.toString()));
                    }
                }
            });
        }
    }

    private void onSuccessfulResponse(String response, String requestId, TBRecommendationRequestCallback listener) {
        final TBRecommendationsRequest request = this.mRequestMap.get(requestId);
        this.mRequestMap.remove(requestId);
        TBRecommendationsResponse body = new TypeAdapterTBRecommendationResponse().deserializeTBRecommendationsResponse(this.mPublisherId, response);
        for (Map.Entry<String, TBPlacement> placementEntry : body.getPlacementsMap().entrySet()) {
            final TBPlacement placementValue = placementEntry.getValue();
            TBPlacementRequest tbPlacementRequest = request.getPlacementRequests().get(placementEntry.getKey());
            if (tbPlacementRequest == null) {
                tbPlacementRequest = request.getPlacementRequests().values().iterator().next();
            }
            boolean isAvailable = tbPlacementRequest.getAvailable();
            placementValue.setHasReportedAvailability(isAvailable);
            if (isAvailable) {
                for (TBRecommendationItem item : placementValue.getItems()) {
                    Map<String, List<String>> trackingPixelMap = item.getTrackingPixelMap();
                    if (trackingPixelMap == null || trackingPixelMap.isEmpty()) continue;
                    List<String> visibleTrackingPixelUrls = trackingPixelMap.get(PIXEL_EVENT_AVAILABLE);
                    this.sendTrackingPixel(visibleTrackingPixelUrls, PIXEL_EVENT_AVAILABLE);
                }
            }
            TBRecommendationsRequest nextBatchRequest = request.createNextBatchRequest(placementEntry.getKey());
            placementValue.setNextBatchRequest(nextBatchRequest);
            placementValue.setName(placementEntry.getKey());
            if (!this.isSdkMonitorEnabled()) continue;
            this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    Messenger placementMessenger = new Messenger((Handler)placementValue.getApiMonitorHandler());
                    MonitorManager monitorManager = TBPublisherApi.this.getSdkMonitorManager();
                    monitorManager.sendApiReceived(placementValue.getId(), placementValue.getName(), placementMessenger);
                    monitorManager.sendApiProperties(placementValue.getId(), TBPublisherApi.this.generateMonitorDebugParams(request));
                }
            });
        }
        this.setUserSession(body.getSession());
        listener.onRecommendationsFetched(body);
    }

    @NonNull
    private Map<String, String> getPlacementDescriptionParams(String responseId) {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put(RESPONSE_ID, responseId);
        queryParameters.put(RESPONSE_SESSION, this.getUserSession());
        queryParameters.put(APP_TYPE, MOBILE);
        queryParameters.put(APP_APIKEY, this.apiKey);
        return queryParameters;
    }

    @NonNull
    private Map<String, String> getNotifyClickRequestParams(String placementId, String itemType, String itemId) {
        Map<String, String> queryParameters = this.getPlacementDescriptionParams(placementId);
        queryParameters.put(ITEM_TYPE, itemType);
        queryParameters.put(ITEM_ID, itemId);
        return queryParameters;
    }

    @NonNull
    private Map<String, String> getFetchRecommendationsParams(TBRecommendationsRequest request, String requestUuid) {
        TBUrlParamsChange paramsChange;
        this.mRequestMap.put(requestUuid, request);
        HashMap<String, String> queryParameters = request.generateQueryParameters();
        if (this.isSdkMonitorEnabled() && this.mTaboolaApi.isShouldMonitorNetwork() && (paramsChange = (TBUrlParamsChange)this.mTaboolaApi.getFeature(3)) != null && !TextUtils.isEmpty((CharSequence)paramsChange.getParams())) {
            String[] separated;
            for (String param : separated = paramsChange.getParams().split("&")) {
                String[] keyV = param.split("=");
                queryParameters.put(keyV[0], keyV[1]);
            }
        }
        queryParameters.put(REQUEST_ID_KEY, requestUuid);
        return queryParameters;
    }

    private HashMap<String, String> generateMonitorDebugParams(TBRecommendationsRequest request) {
        HashMap<String, String> parameters = request.generateQueryParameters();
        parameters.put("publisher", this.mPublisherId);
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUserSession() {
        Object object = this.mUserSessionLock;
        synchronized (object) {
            return SharedPrefUtil.getUserSession(this.getAppContext(), this.mPublisherId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUserSession(String userSession) {
        Object object = this.mUserSessionLock;
        synchronized (object) {
            Context appCtx = this.getAppContext();
            SharedPrefUtil.setUserSession(appCtx, userSession, this.mPublisherId);
            SharedPrefUtil.setUserSessionTimestamp(appCtx, System.currentTimeMillis(), this.mPublisherId);
        }
    }

    private void sendBridgeToKibana() {
        try {
            JSONObject event = new JSONObject();
            if (this.mDefaultSdf == null) {
                this.createDataFormat();
            }
            String formattedDate = this.mDefaultSdf.format(new Date());
            event.put(ADDITIONAL_DATA, (Object)SdkDetailsHelper.createSdkDetailsJSON(this.getAppContext(), null, "Taboola Android SDK - API"));
            event.put(DEVICE, (Object)(TextUtils.isEmpty((CharSequence)this.mAdvertisingId) ? "undefined" : this.mAdvertisingId));
            event.put(PUBLISHER_ID, (Object)this.mPublisherId);
            event.put(API_KEY, (Object)this.apiKey);
            event.put(TIMESTAMP, (Object)formattedDate);
            event.put(EVENT, (Object)MOBILE_INIT);
            event.put(SHOULD_ALLOW_NON_ORGANIC_CLICK_OVERRIDE, this.mShouldAllowNonOrganicClickOverride);
            event.put(IS_ENABLED_RAW_DATA_RESPONSE, this.mIsEnabledRawDataResponse);
            event.put(USE_HTTP, this.mUseHttp);
            if (this.mApiParams != null) {
                event.put(API_PARAMS, (Object)new JSONObject(this.mApiParams));
            }
            event.put("taboolaConfig", (Object)this.mConfigManager.getConfigurationAsJsonString());
            this.mNetworkManager.getKibanaHandler().sendEvent(event);
        }
        catch (Exception e) {
            Logger.e(TAG, "sendEventToKibana " + e.getMessage());
        }
    }

    public String getPublisherId() {
        return this.mPublisherId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void clear() {
        Log.d((String)TAG, (String)(this.mPublisherId + ", clear() called "));
        this.mOnClickListener = null;
        this.mSdkEventsTestListener = null;
        this.mRecommendationsAPI = null;
        this.mImagePlaceholderDrawable = null;
        this.mOverrideImageLoad = false;
        this.mOverrideBaseUrl = null;
        this.mTaboolaApi = null;
        if (this.mUiHandler != null) {
            this.mUiHandler.removeCallbacksAndMessages(null);
            this.mUiHandler = null;
        }
    }

    public void setImageErrorListener(TBImageErrorListener tbImageErrorListener) {
        this.checkIsInitialize();
        this.mTaboolaApi.setImageErrorListener(tbImageErrorListener);
    }

    Context getAppContext() {
        if (this.mTaboolaApi == null) {
            return null;
        }
        return this.mTaboolaApi.getApplicationContext();
    }

    boolean isSdkMonitorEnabled() {
        return this.mTaboolaApi.isSdkMonitorEnabled();
    }

    private MonitorManager getSdkMonitorManager() {
        return this.mTaboolaApi.getSdkMonitorManager();
    }

    public void sendApiAvailable(final String id) {
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                TBPublisherApi.this.getSdkMonitorManager().sendApiAvailable(id);
            }
        });
    }

    public void sendApiVisible(final String id) {
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                TBPublisherApi.this.getSdkMonitorManager().sendApiVisible(id);
            }
        });
    }

    private void addGdprInfo(TBRecommendationsRequest request) {
        String subjectToGdpr = GDPRUtils.getSubjectToGdpr(this.getAppContext());
        if (subjectToGdpr.toLowerCase().equals("true")) {
            request.setIABSubjectToGdpr(subjectToGdpr);
            request.setIABDaisyBit(GDPRUtils.getConsentString(this.getAppContext()));
        }
    }
}

