/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.testing.tests;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taboola.android.integration_verifier.testing.VerificationTest;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTarget;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTargets;
import com.taboola.android.integration_verifier.utility.IntegrationTypeNameParser;
import com.taboola.android.utils.MonitorUtils;

public class WidgetLayoutParamsVerificationTest
extends VerificationTest {
    private static final String TAG = "WidgetLayoutParamsVerif";
    private static final String TEST_NAME = "WidgetLayoutParamsVerification";
    public static final String HEIGHT_PARAM = "WidgetLayoutParamsVerif.heightParam";
    private static final String BUNDLE_NULL_ERROR = "WidgetLayoutParamsVerification Bundle should never null.";
    private static final String ILLEGAL_VALUE_ERROR = "WidgetLayoutParamsVerificationTest | Height param was set to %s, please use fixed size (1-2 screen size) in case you have feed or big widget";
    private String mErrorMsg;

    public WidgetLayoutParamsVerificationTest(int id, boolean isMandatory) {
        super(id, isMandatory);
    }

    @Override
    public void execute(@Nullable Context context, @Nullable Bundle bundle, @NonNull VerificationTest.TestResults testResults) {
        if (this.widgetParamsVerified(bundle)) {
            testResults.onSuccess();
        } else {
            testResults.onFail(this.isMandatory());
        }
    }

    private boolean widgetParamsVerified(Bundle bundle) {
        if (bundle == null) {
            this.mErrorMsg = BUNDLE_NULL_ERROR;
            return false;
        }
        int heightLayoutParam = bundle.getInt(HEIGHT_PARAM);
        if (heightLayoutParam < 0) {
            this.mErrorMsg = String.format(ILLEGAL_VALUE_ERROR, MonitorUtils.sizeToString(heightLayoutParam));
            return false;
        }
        return true;
    }

    @Override
    public VerificationOutputTargets getVerificationOutputTargets(@Nullable Bundle bundle) {
        VerificationOutputTargets verificationOutputTargets = new VerificationOutputTargets(new VerificationOutputTarget[0]);
        Bundle consoleBundle = new Bundle();
        consoleBundle.putString("consoleOutput_key_log_error_string", this.mErrorMsg);
        verificationOutputTargets.add(new VerificationOutputTarget(2, consoleBundle));
        verificationOutputTargets.add(new VerificationOutputTarget(3, this.getKibanaBundle(IntegrationTypeNameParser.getNameFor(bundle.getInt("integration_verifier_key_integrationType")), TEST_NAME, this.mErrorMsg)));
        return verificationOutputTargets;
    }
}

