/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network.handlers;

import android.support.annotation.Keep;
import android.util.Log;
import com.taboola.android.global_components.network.requests.kusto.GlobalExceptionKustoReport;
import com.taboola.android.global_components.network.requests.kusto.KustoRequest;
import com.taboola.lightnetwork.dynamic_url.DynamicRequest;
import com.taboola.lightnetwork.dynamic_url.NetworkExecutable;
import com.taboola.lightnetwork.dynamic_url.annotations.GET;
import com.taboola.lightnetwork.dynamic_url.annotations.Query;
import com.taboola.lightnetwork.protocols.http.HttpManager;

@Keep
public class KustoHandler {
    private static final String KUSTO_TR_5_URL = "https://cdn.taboola.com/libtrc/tr5";
    private final KustoApiService mKustoApiService;
    private static final String TAG = "KustoHandler";

    public KustoHandler(HttpManager httpManager) {
        NetworkExecutable networkExecutable = new NetworkExecutable(httpManager);
        this.mKustoApiService = networkExecutable.create(KustoApiService.class);
    }

    public void sendGUEHExceptionToKusto(GlobalExceptionKustoReport exceptionReport, HttpManager.NetworkResponse networkResponse) {
        this.sendEventToKusto(exceptionReport, networkResponse);
    }

    private void sendEventToKusto(KustoRequest kustoEvent, HttpManager.NetworkResponse networkResponse) {
        try {
            String data = kustoEvent.getJsonBody().toString(2);
            DynamicRequest request = this.mKustoApiService.sendEvent(data);
            request.execute(networkResponse);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("sendEventToKusto: error " + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    static interface KustoApiService {
        @GET(value="https://cdn.taboola.com/libtrc/tr5")
        public DynamicRequest sendEvent(@Query(value="data") String var1);
    }
}

