/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.eventsmanager;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.taboola.android.global_components.eventsmanager.events.TaboolaEvent;
import com.taboola.android.global_components.eventsmanager.events.TaboolaMobileEvent;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.SharedPrefUtil;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventQueue
extends LinkedList<TaboolaEvent> {
    private static final String TAG = EventQueue.class.getSimpleName();
    private static final String JSON_KEY_EVENT_TYPE = "eventType";
    private static final String EVENT_TYPE_MOBILE_EVENT = "mobile";
    private static int sQueueMaxSize = 100;
    private Context mContext;

    public EventQueue(Context context) {
        this.mContext = context;
    }

    public synchronized void addEvent(TaboolaEvent ... events) {
        this.makeRoomIfNeeded(events);
        for (TaboolaEvent event : events) {
            this.addLast(event);
        }
        this.saveQueue();
    }

    private void makeRoomIfNeeded(TaboolaEvent[] events) {
        int incomingEventsNum = events.length;
        if (this.size() > sQueueMaxSize - incomingEventsNum) {
            for (int i = 0; i < incomingEventsNum; ++i) {
                try {
                    this.pop();
                    continue;
                }
                catch (NoSuchElementException nsee) {
                    Logger.e(TAG, "EventsQueue reached max size (" + sQueueMaxSize + ") but can't remove oldest event.");
                }
            }
        }
    }

    @Nullable
    public synchronized TaboolaEvent popFirstEvent() {
        TaboolaEvent firstInQueue = null;
        try {
            firstInQueue = (TaboolaEvent)this.pop();
            this.saveQueue();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return firstInQueue;
    }

    private void saveQueue() {
        String eventQueueString = this.toString();
        if (eventQueueString.length() < Integer.MAX_VALUE) {
            SharedPrefUtil.saveEventsQueue(this.mContext, eventQueueString);
        } else {
            Logger.w(TAG, "Warning: Taboola events queue is fully, not persisting new events (they still exist in memory).");
        }
    }

    public void loadQueue() {
        String sPrefsQueue = SharedPrefUtil.loadEventsQueue(this.mContext);
        if (!TextUtils.isEmpty((CharSequence)sPrefsQueue)) {
            try {
                JSONArray eventsJsonArray = new JSONArray(sPrefsQueue);
                block8: for (int i = 0; i < eventsJsonArray.length(); ++i) {
                    String eventType;
                    JSONObject event = eventsJsonArray.getJSONObject(i);
                    switch (eventType = event.getString(JSON_KEY_EVENT_TYPE)) {
                        case "mobile": {
                            this.addEvent(new TaboolaMobileEvent(null).fromJson(event));
                            continue block8;
                        }
                        default: {
                            Logger.e(TAG, "Issue loading queue, event type unrecognizable (" + eventType + ").");
                        }
                    }
                }
            }
            catch (JSONException e) {
                Logger.e(TAG, "Failed loading queue, exception: " + e.getLocalizedMessage());
            }
        }
    }

    public void setMaxSize(int queueMaxSize) {
        sQueueMaxSize = queueMaxSize;
    }

    public int getMaxSize() {
        return sQueueMaxSize;
    }

    @Override
    @NonNull
    public synchronized String toString() {
        String eventsString = "";
        try {
            if (this.isEmpty()) {
                return eventsString;
            }
            StringBuilder stringBuilder = new StringBuilder("[");
            for (TaboolaEvent event : this) {
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(event.toString());
            }
            stringBuilder.append("]");
            eventsString = stringBuilder.toString();
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return eventsString;
    }
}

