/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.lightnetwork.protocols.http;

import android.content.Context;
import android.net.http.HttpResponseCache;
import android.util.Log;
import com.taboola.lightnetwork.protocols.http.CookiesTracker;
import com.taboola.lightnetwork.protocols.http.HeadersManager;
import com.taboola.lightnetwork.protocols.http.HttpError;
import com.taboola.lightnetwork.protocols.http.HttpGet;
import com.taboola.lightnetwork.protocols.http.HttpPost;
import com.taboola.lightnetwork.protocols.http.HttpResponse;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.json.JSONObject;

public class HttpManager {
    private static final String TAG = HttpManager.class.getSimpleName();
    private static final int DEFAULT_TIMEOUT_MILLIS = 10000;
    private static final int MAX_HTTP_RESPONSE_CACHE_SIZE_MB = 10;
    private HeadersManager mHeadersManager = new HeadersManager();
    private CookiesTracker mCookiesTracker;

    public HttpManager(Context context) {
        this.mCookiesTracker = new CookiesTracker(context);
        this.setupCache(context);
    }

    public void get(String url) {
        new HttpGet(this.mHeadersManager, this.mCookiesTracker, 10000).get(url, null, null, null, null);
    }

    public void get(String url, NetworkResponse networkResponse) {
        new HttpGet(this.mHeadersManager, this.mCookiesTracker, 10000).get(url, null, null, null, networkResponse);
    }

    public void get(String url, String trackHeadersKey, String trackHeadersByGroup, NetworkResponse networkResponse) {
        new HttpGet(this.mHeadersManager, this.mCookiesTracker, 10000).get(url, null, trackHeadersKey, trackHeadersByGroup, networkResponse);
    }

    public void get(String url, Map<String, String> requestHeaders, String trackHeadersKey, String trackHeadersByGroup, NetworkResponse networkResponse) {
        new HttpGet(this.mHeadersManager, this.mCookiesTracker, 10000).get(url, requestHeaders, trackHeadersKey, trackHeadersByGroup, networkResponse);
    }

    public void post(String url, JSONObject jsonBody) {
        new HttpPost(this.mHeadersManager, this.mCookiesTracker, 10000).post(url, jsonBody, null, null, null, null);
    }

    public void post(String url, JSONObject jsonBody, NetworkResponse networkResponse) {
        new HttpPost(this.mHeadersManager, this.mCookiesTracker, 10000).post(url, jsonBody, null, null, null, networkResponse);
    }

    public void post(String url, JSONObject jsonBody, String trackHeadersKey, String trackHeadersByGroup, NetworkResponse networkResponse) {
        new HttpPost(this.mHeadersManager, this.mCookiesTracker, 10000).post(url, jsonBody, null, trackHeadersKey, trackHeadersByGroup, networkResponse);
    }

    public void post(String url, JSONObject jsonBody, Map<String, String> requestHeaders, String trackHeadersKey, String trackHeadersByGroup, NetworkResponse networkResponse) {
        new HttpPost(this.mHeadersManager, this.mCookiesTracker, 10000).post(url, jsonBody, requestHeaders, trackHeadersKey, trackHeadersByGroup, networkResponse);
    }

    private void setupCache(Context context) {
        try {
            File httpCacheDir = new File(context.getCacheDir(), "http");
            long httpCacheSize = 0xA00000L;
            HttpResponseCache.install((File)httpCacheDir, (long)httpCacheSize);
        }
        catch (NullPointerException npe) {
            Log.e((String)TAG, (String)("Cannot define cache size: " + npe.getLocalizedMessage()));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("HTTP response cache installation failed:" + e));
        }
    }

    public static interface NetworkResponse {
        public void onResponse(HttpResponse var1);

        public void onError(HttpError var1);
    }
}

