/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.lightnetwork;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.Log;
import com.taboola.lightnetwork.utils.PermissionUtils;

public class State {
    private static final String TAG = State.class.getSimpleName();
    private final Context mContext;

    public State(Context context) {
        this.mContext = context;
    }

    public boolean isConnected() {
        if (Build.VERSION.SDK_INT >= 28) {
            return this.isConnected_Q();
        }
        return this.isConnected_preQ();
    }

    public boolean isConnectedThroughWifi() {
        if (Build.VERSION.SDK_INT >= 28) {
            return this.isConnectedThroughWifi_Q();
        }
        return this.isConnectedThroughWifi_preQ();
    }

    @TargetApi(value=23)
    @SuppressLint(value={"MissingPermission"})
    private boolean isConnected_Q() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        if (connectivityManager != null) {
            Network activeNetwork = connectivityManager.getActiveNetwork();
            if (activeNetwork == null) {
                return false;
            }
            NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(activeNetwork);
            if (networkCapabilities != null && this.isConnectionValidated(networkCapabilities)) {
                return true;
            }
        }
        return false;
    }

    private boolean isConnected_preQ() {
        if (this.checkNetworkStatePermission()) {
            return false;
        }
        NetworkInfo activeNetworkInfo = this.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    @TargetApi(value=23)
    @SuppressLint(value={"MissingPermission"})
    private boolean isConnectedThroughWifi_Q() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        if (connectivityManager != null) {
            Network activeNetwork = connectivityManager.getActiveNetwork();
            if (activeNetwork == null) {
                return false;
            }
            NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(activeNetwork);
            if (networkCapabilities != null && this.isConnectionValidated(networkCapabilities) && this.isWifiTypeConnection(networkCapabilities)) {
                return true;
            }
        }
        return false;
    }

    private boolean isConnectedThroughWifi_preQ() {
        if (this.checkNetworkStatePermission()) {
            return false;
        }
        NetworkInfo activeNetworkInfo = this.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected() && activeNetworkInfo.getType() == 1;
    }

    @TargetApi(value=21)
    private boolean isWifiTypeConnection(NetworkCapabilities networkCapabilities) {
        return networkCapabilities.hasTransport(1);
    }

    @TargetApi(value=23)
    private boolean isConnectionValidated(NetworkCapabilities networkCapabilities) {
        return networkCapabilities.hasCapability(16);
    }

    private boolean checkNetworkStatePermission() {
        if (!PermissionUtils.isPermissionGranted(this.mContext, "android.permission.ACCESS_NETWORK_STATE")) {
            Log.d((String)TAG, (String)"isConnected() | Failed to check connectivity, ACCESS_NETWORK_STATE permission not asked or granted.");
            return true;
        }
        return false;
    }

    @SuppressLint(value={"MissingPermission"})
    private NetworkInfo getActiveNetworkInfo() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        return connectivityManager == null ? null : connectivityManager.getActiveNetworkInfo();
    }
}

