/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.eventsmanager.events;

import android.support.annotation.Keep;
import com.taboola.android.global_components.eventsmanager.EventType;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.utils.Logger;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public abstract class TaboolaEvent
extends HashMap<String, String> {
    private static final String TAG = TaboolaEvent.class.getSimpleName();
    private static final String JSON_KEY_EVENT_TYPE = "eventType";
    private String mType;

    public TaboolaEvent(@EventType String type) {
        this.mType = type;
    }

    public abstract boolean isValid();

    public void sendEvent(NetworkManager networkManager, SendEventCallback sendEventCallback) {
        if (!this.isValid()) {
            Logger.d(TAG, "Event is not valid.");
            sendEventCallback.onFailure();
            return;
        }
        this.extendedSendEvent(networkManager, sendEventCallback);
    }

    public abstract void extendedSendEvent(NetworkManager var1, SendEventCallback var2);

    public void setType(String type) {
        this.mType = type;
    }

    public String getType() {
        return this.mType;
    }

    public TaboolaEvent fromJson(JSONObject jsonObject) {
        try {
            if (jsonObject == null) {
                Logger.e(TAG, "Cannot load TaboolaEvent from JSON, jsonObject is null.");
                return null;
            }
            this.setType(jsonObject.optString(JSON_KEY_EVENT_TYPE));
            this.extendedFromJson(jsonObject);
        }
        catch (Exception e) {
            Logger.e(TAG, "Exception: " + e.getLocalizedMessage());
        }
        return this;
    }

    public abstract TaboolaEvent extendedFromJson(JSONObject var1);

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(JSON_KEY_EVENT_TYPE, (Object)this.getType());
            jsonObject = this.extendedToJson(jsonObject);
        }
        catch (JSONException e) {
            Logger.e(TAG, e.getMessage());
        }
        return jsonObject;
    }

    public abstract JSONObject extendedToJson(JSONObject var1) throws JSONException;

    @Override
    public String toString() {
        JSONObject jsonObject = this.toJson();
        return jsonObject == null ? "{}" : jsonObject.toString();
    }

    public static interface SendEventCallback {
        public void onSuccess();

        public void onFailure();
    }
}

