/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.eventsmanager.session;

import com.taboola.android.PublisherInfo;
import com.taboola.android.global_components.eventsmanager.SessionInfo;
import com.taboola.android.global_components.eventsmanager.session.GetSessionListener;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.utils.Logger;
import com.taboola.lightnetwork.protocols.http.HttpError;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import com.taboola.lightnetwork.protocols.http.HttpResponse;
import java.util.ArrayList;

public class ReportEventsSessionManager {
    private static final String TAG = ReportEventsSessionManager.class.getSimpleName();
    private NetworkManager mNetworkManager;
    public ArrayList<GetSessionListener> mGetSessionListenersList;
    private SessionInfo mDownloadedSessionInfo;
    private boolean mIsDownloadingSession;

    public ReportEventsSessionManager(NetworkManager networkManager) {
        this.mNetworkManager = networkManager;
        this.mGetSessionListenersList = new ArrayList();
        this.mIsDownloadingSession = false;
    }

    public synchronized void getSession(PublisherInfo publisherInfo, SessionInfo callingSessionInfo, GetSessionListener getSessionListener) {
        if (callingSessionInfo != null && callingSessionInfo.isValid()) {
            Logger.d(TAG, "getSession | Using calling session info in memory.");
            getSessionListener.onSessionRetrieved(callingSessionInfo);
            return;
        }
        if (this.mDownloadedSessionInfo != null && this.mDownloadedSessionInfo.isValid()) {
            Logger.d(TAG, "getSession | Using downloaded session info (existing session in memory).");
            getSessionListener.onSessionRetrieved(this.mDownloadedSessionInfo);
            return;
        }
        this.getSessionFromServer(publisherInfo, getSessionListener);
    }

    private void getSessionFromServer(PublisherInfo publisherInfo, GetSessionListener getSessionListener) {
        this.mGetSessionListenersList.add(getSessionListener);
        if (this.mIsDownloadingSession) {
            Logger.d(TAG, "getSessionFromServer | Currently downloading, adding listener.");
        } else {
            Logger.d(TAG, "getSessionFromServer | Fetching session info from server...");
            this.mIsDownloadingSession = true;
            this.mNetworkManager.getEventsManagerHandler().getSessionInfo(publisherInfo, new HttpManager.NetworkResponse(){

                @Override
                public void onResponse(HttpResponse response) {
                    Logger.d(TAG, "getSessionFromServer | got session!");
                    SessionInfo serverSessionInfo = new SessionInfo(response.mMessage);
                    if (serverSessionInfo != null && serverSessionInfo.isValid()) {
                        Logger.d(TAG, "getSessionFromServer | New server session valid.");
                        ReportEventsSessionManager.this.mDownloadedSessionInfo = serverSessionInfo;
                        for (GetSessionListener sessionListener : ReportEventsSessionManager.this.mGetSessionListenersList) {
                            sessionListener.onSessionRetrieved(ReportEventsSessionManager.this.mDownloadedSessionInfo);
                        }
                        ReportEventsSessionManager.this.mGetSessionListenersList.clear();
                    } else {
                        Logger.e(TAG, "getSessionFromServer | Session invalid, not sending events.");
                    }
                    ReportEventsSessionManager.this.mIsDownloadingSession = false;
                }

                @Override
                public void onError(HttpError error) {
                    Logger.e(TAG, "getSessionFromServer | Error retrieving sessionInfo, cannot currently send events. Error: " + error.toString());
                    ReportEventsSessionManager.this.mIsDownloadingSession = false;
                }
            });
        }
    }
}

