/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network.requests.kusto;

import android.content.Context;
import com.taboola.android.global_components.network.requests.kusto.KustoRequest;
import com.taboola.android.utils.JSONUtils;
import com.taboola.android.utils.Logger;
import java.util.Arrays;
import org.json.JSONObject;

public class GlobalExceptionKustoReport
extends KustoRequest {
    private static final String TAG = "GlobalExceptionReport";
    private static final String UNCAUGHT_EXCEPTION_EVENT = "UncaughtException";
    private static final String EXCEPTION_MESSAGE = "exceptionMessage";
    private static final String EXCEPTION_STACK_TRACE = "exceptionStackTrace";
    private final String mMessage;
    private final String mStackTrace;

    public GlobalExceptionKustoReport(Context context, Throwable ex) {
        super(context);
        this.mMessage = ex.getMessage();
        this.mStackTrace = Arrays.toString(ex.getStackTrace());
    }

    @Override
    public JSONObject getJsonBody() {
        try {
            JSONObject jsonReportBody = super.getJsonBody();
            jsonReportBody.put(EXCEPTION_MESSAGE, JSONUtils.getJsonNullIfNeeded(this.mMessage));
            jsonReportBody.put(EXCEPTION_STACK_TRACE, JSONUtils.getJsonNullIfNeeded(this.mStackTrace));
            return jsonReportBody;
        }
        catch (Exception e) {
            Logger.e(TAG, "GlobalExceptionReport | getJsonBody | Failed to extract Json from object.");
            return new JSONObject();
        }
    }

    @Override
    String getEventType() {
        return UNCAUGHT_EXCEPTION_EVENT;
    }

    @Override
    String getTag() {
        return TAG;
    }
}

