/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network.requests.kibana;

import com.taboola.android.global_components.network.requests.kibana.KibanaRequest;
import com.taboola.android.utils.JSONUtils;
import com.taboola.android.utils.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class GlobalExceptionKibanaReport
extends KibanaRequest {
    private static final String TAG = GlobalExceptionKibanaReport.class.getSimpleName();
    private static final String KIBANA_KEY_VERIFIER_PACKAGE_NAME = "packageName";
    private static final String KIBANA_KEY_VERIFIER_EXCEPTION = "exception";
    private static final String KIBANA_KEY_VERIFIER_DEVICE_ID = "deviceId";
    private static final String KIBANA_KEY_VERIFIER_STACK_TRACE = "stackTrace";
    private final String packageName;
    private final String exception;
    private final String deviceId;
    private final String stackTrace;

    public GlobalExceptionKibanaReport(String packageName, String exception, String sdkVer, String timestamp, String deviceId, String stackTrace) {
        super(sdkVer, timestamp);
        this.packageName = packageName;
        this.exception = exception;
        this.deviceId = deviceId;
        this.stackTrace = stackTrace;
    }

    public JSONObject getJsonBody() {
        JSONObject jsonReportBody = new JSONObject();
        try {
            jsonReportBody.put(KIBANA_KEY_VERIFIER_PACKAGE_NAME, (Object)this.packageName);
            jsonReportBody.put(KIBANA_KEY_VERIFIER_EXCEPTION, JSONUtils.getJsonNullIfNeeded(this.exception));
            jsonReportBody.put("sdk_version", (Object)this.sdkVer);
            jsonReportBody.put("timestamp", (Object)this.timestamp);
            jsonReportBody.put(KIBANA_KEY_VERIFIER_DEVICE_ID, JSONUtils.getJsonNullIfNeeded(this.deviceId));
            jsonReportBody.put(KIBANA_KEY_VERIFIER_STACK_TRACE, JSONUtils.getJsonNullIfNeeded(this.stackTrace));
        }
        catch (JSONException e) {
            Logger.e(TAG, "GlobalExceptionReport | getJsonBody | Failed to extract Json from object.");
        }
        return jsonReportBody;
    }
}

