/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils;

import android.content.Context;
import android.os.Build;
import android.support.annotation.Keep;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.PopupDialogFragment;

@Keep
public class PopupHelper {
    private static final String TAG = PopupHelper.class.getSimpleName();

    public static boolean openPopup(Context context, String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            Logger.e(TAG, "Can't show popup, url = null");
            return false;
        }
        boolean activityAvailableForShowPopup = context instanceof FragmentActivity;
        if (activityAvailableForShowPopup) {
            FragmentActivity activity = (FragmentActivity)context;
            boolean bl = activityAvailableForShowPopup = !activity.isFinishing() && (Build.VERSION.SDK_INT < 17 || !activity.isDestroyed());
        }
        if (!activityAvailableForShowPopup) {
            Logger.e(TAG, "Can't show popup, Activity is not available");
            return false;
        }
        return PopupDialogFragment.showPopup((FragmentActivity)context, url);
    }
}

