/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network.http;

import android.support.annotation.Nullable;
import com.taboola.android.global_components.network.http.HeadersManager;
import com.taboola.android.global_components.network.http.HttpManager;
import com.taboola.android.global_components.network.http.HttpRequest;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import org.json.JSONObject;

class HttpPost
extends HttpRequest {
    private JSONObject mJsonBody;

    public HttpPost(HeadersManager headersManager, int configuredTimeout) {
        super(configuredTimeout, headersManager);
    }

    void post(String url, @Nullable JSONObject jsonBody, String trackHeader, @Nullable HttpManager.NetworkResponse networkResponse) {
        this.mUrl = url;
        this.mJsonBody = jsonBody;
        this.mTrackHeaders = trackHeader;
        this.performRequsetOnBackgroundThread(networkResponse);
    }

    @Override
    void protocolSpecificConnectionSetup(HttpURLConnection httpUrlConnection) throws IOException {
        httpUrlConnection.setRequestMethod("POST");
        httpUrlConnection.setDoInput(true);
        httpUrlConnection.setDoOutput(true);
        this.addJsonBody(httpUrlConnection);
    }

    private void addJsonBody(HttpURLConnection httpUrlConnection) throws IOException {
        JSONObject jsonBody = this.mJsonBody;
        if (jsonBody != null && jsonBody.length() > 0) {
            DataOutputStream writer = new DataOutputStream(httpUrlConnection.getOutputStream());
            writer.writeBytes(jsonBody.toString());
            writer.flush();
            writer.close();
        }
    }
}

