/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.OnClickHelper;
import com.taboola.android.utils.SdkDetailsHelper;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public class RequestUtil {
    private static final String TAG = RequestUtil.class.getSimpleName();

    public static void performPreClickCallAsync(final Context applicationContext, final String publisherId, final String clickUrl, final String sdkType) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (applicationContext != null) {
                    RequestUtil.performPreClickCall(applicationContext, publisherId, clickUrl, sdkType);
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performPreClickCall(Context applicationContext, String publisherId, String clickUrl, String sdkType) {
        String url = String.format("https://tracking.taboola.com/mobile/%1$s/click/pre-click", publisherId);
        String expectedBrowser = SdkDetailsHelper.getDefaultBrowser(applicationContext);
        if (TextUtils.isEmpty((CharSequence)expectedBrowser)) {
            expectedBrowser = "undefined";
        } else if (OnClickHelper.areChromeCustomTabsSupported(applicationContext)) {
            expectedBrowser = expectedBrowser + " (Custom tab)";
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpsURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("cache-control", "no-cache");
            connection.setRequestProperty("x-tracking-click-url", clickUrl);
            connection.setRequestProperty("x-tracking-expected-post-click-browser", expectedBrowser);
            connection.setRequestProperty("x-tracking-os", "Android");
            connection.setRequestProperty("x-tracking-os-version", Build.VERSION.RELEASE);
            connection.setRequestProperty("x-tracking-sdk-type", sdkType);
            connection.setRequestProperty("x-tracking-sdk-version", "2.2.1-43428-3");
            connection.connect();
        }
        catch (MalformedURLException e) {
            Logger.e(TAG, "performPreClickCallAsync: " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            Logger.e(TAG, "performPreClickCallAsync: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

