/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import com.taboola.android.global_components.TaboolaContextManager;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.PermissionUtils;

@Keep
public class State {
    private static final String TAG = State.class.getSimpleName();
    private final Context mContext = TaboolaContextManager.getInstance().getApplicationContext();

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isConnected() {
        if (this.checkNetworkStatePermission()) {
            return false;
        }
        NetworkInfo activeNetworkInfo = this.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isConnectedThroughWifi() {
        if (this.checkNetworkStatePermission()) {
            return false;
        }
        NetworkInfo activeNetworkInfo = this.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected() && activeNetworkInfo.getType() == 1;
    }

    private boolean checkNetworkStatePermission() {
        if (!PermissionUtils.isPermissionGranted(this.mContext, "android.permission.ACCESS_NETWORK_STATE")) {
            Logger.d(TAG, "isConnected() | Failed to check connectivity, ACCESS_NETWORK_STATE permission not asked or granted.");
            return true;
        }
        return false;
    }

    @Nullable
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private NetworkInfo getActiveNetworkInfo() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        return connectivityManager == null ? null : connectivityManager.getActiveNetworkInfo();
    }
}

