/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taboola.android.utils.Logger;

public class SharedPrefUtil {
    private static final String TAG = SharedPrefUtil.class.getSimpleName();
    private static final String SHARED_PREFS_KEY = "com.taboola.android.SHARED_PREFERENCES_KEY";
    private static final String ADVERTISING_ID_SHARED_PREFS_KEY = "com.taboola.android.ADVERTISING_ID_SHARED_PREFERENCES_KEY";
    private static final String MAX_WIDGET_SIZE_SHARED_PREFS_KEY = "com.taboola.android.MAX_WIDGET_SIZE_SHARED_PREFS_KEY";
    private static final String API_SESSION_SHARED_PREFS_KEY = "com.taboola.android.API_SESSION_SHARED_PREFS_KEY";
    private static final String API_SESSION_TIMESTAMP_SHARED_PREFS_KEY = "com.taboola.android.API_SESSION_TIMESTAMP_SHARED_PREFS_KEY";
    private static final String ISO_CODE = "com.taboola.android.ISO_CODE";
    private static final long SESSION_EXPIRATION_PERIOD_MS = 3600000L;

    static String getCachedAdvertisingId(Context context) {
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFS_KEY, 0);
        String id2 = preferences.getString(ADVERTISING_ID_SHARED_PREFS_KEY, null);
        Logger.d(TAG, "getCachedAdvertisingId :: id = " + id2);
        return id2;
    }

    static void setCachedAdvertisingId(Context context, String idValue) {
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFS_KEY, 0);
        preferences.edit().putString(ADVERTISING_ID_SHARED_PREFS_KEY, idValue).apply();
    }

    public static int getCachedMaxWidgetSize(Context context) {
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFS_KEY, 0);
        int size = preferences.getInt(MAX_WIDGET_SIZE_SHARED_PREFS_KEY, 0);
        Logger.d(TAG, "getCachedMaxWidgetSize :: Size = " + size);
        return size;
    }

    public static void setCachedMaxWidgetSize(Context context, int size) {
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFS_KEY, 0);
        preferences.edit().putInt(MAX_WIDGET_SIZE_SHARED_PREFS_KEY, size).apply();
    }

    @Nullable
    public static String getUserSession(Context context, String publisherId) {
        boolean isExpired;
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFS_KEY, 0);
        String session = preferences.getString(API_SESSION_SHARED_PREFS_KEY + SharedPrefUtil.getPublisherSuffixKey(publisherId), "init");
        long sessionAcquisitionTimestamp = SharedPrefUtil.getUserSessionTimestamp(context, publisherId);
        boolean bl = isExpired = System.currentTimeMillis() > sessionAcquisitionTimestamp + 3600000L;
        if (isExpired) {
            return "init";
        }
        return session;
    }

    public static void setUserSession(Context context, String session, String publisherId) {
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFS_KEY, 0);
        preferences.edit().putString(API_SESSION_SHARED_PREFS_KEY + SharedPrefUtil.getPublisherSuffixKey(publisherId), session).apply();
    }

    @Nullable
    public static long getUserSessionTimestamp(Context context, String publisherId) {
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFS_KEY, 0);
        return preferences.getLong(API_SESSION_TIMESTAMP_SHARED_PREFS_KEY + SharedPrefUtil.getPublisherSuffixKey(publisherId), 0L);
    }

    public static void setUserSessionTimestamp(Context context, long timestamp, String publisherId) {
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFS_KEY, 0);
        preferences.edit().putLong(API_SESSION_TIMESTAMP_SHARED_PREFS_KEY + SharedPrefUtil.getPublisherSuffixKey(publisherId), timestamp).apply();
    }

    static String getPublisherSuffixKey(String publisherId) {
        return "_" + publisherId;
    }

    static void saveSimCodeToSharedPreferences(@NonNull Context context, String isoCode) {
        SharedPreferences preferences = SharedPrefUtil.getPreferences(context);
        preferences.edit().putString(ISO_CODE, isoCode).apply();
    }

    static String getCachedSimCode(@NonNull Context context) {
        SharedPreferences preferences = SharedPrefUtil.getPreferences(context);
        return preferences.getString(ISO_CODE, "undefined");
    }

    private static SharedPreferences getPreferences(@NonNull Context context) {
        return context.getApplicationContext().getSharedPreferences(TAG, 0);
    }
}

