/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils.network;

import android.net.Uri;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.network.UrlParameter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class UrlParameters {
    private static final String TAG = UrlParameters.class.getSimpleName();
    private static final String KEY_VALUE_PAIR = "%s=%s";
    protected Set<UrlParameter> parameters = new HashSet<UrlParameter>();

    public void addParameters(UrlParameter ... parameters) {
        for (UrlParameter urlParameter : parameters) {
            this.validateAndAddParameter(urlParameter);
        }
    }

    @Deprecated
    public void addParameters(HashMap<String, String> parameters) {
        Iterator<Map.Entry<String, String>> iterator = parameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> pair = iterator.next();
            this.validateAndAddParameter(new UrlParameter(pair.getKey(), pair.getValue()));
            iterator.remove();
        }
    }

    private void validateAndAddParameter(UrlParameter urlParameter) {
        if (urlParameter.isValid()) {
            this.parameters.add(urlParameter);
        } else {
            Logger.e(TAG, "UrlParameters | addParameters() | Tried to add invalid parameter.");
        }
    }

    public String toString() {
        return this.getString(true);
    }

    public String getString(boolean utf8Encoded) {
        StringBuilder urlStringBuilder = new StringBuilder();
        boolean first = true;
        for (UrlParameter parameter : this.parameters) {
            if (first) {
                first = false;
            } else {
                urlStringBuilder.append("&");
            }
            String key = utf8Encoded ? Uri.encode((String)parameter.key) : parameter.key;
            String value = utf8Encoded ? Uri.encode((String)parameter.value) : parameter.value;
            urlStringBuilder.append(String.format(KEY_VALUE_PAIR, key, value));
        }
        return urlStringBuilder.toString();
    }
}

