/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network.http;

import android.os.Looper;
import com.taboola.android.global_components.network.http.HttpManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

class HttpGet {
    HttpGet() {
    }

    void get(final String url, final HttpManager.NetworkResponse networkResponse) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    HttpGet.this.httpGetRequest(url, networkResponse);
                }
            }).start();
        } else {
            this.httpGetRequest(url, networkResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void httpGetRequest(String url, HttpManager.NetworkResponse networkResponse) {
        HttpURLConnection connection = null;
        try {
            if (url.contains("https://")) {
                connection = (HttpsURLConnection)new URL(url).openConnection();
            } else if (url.contains("http://")) {
                connection = (HttpURLConnection)new URL(url).openConnection();
            } else {
                if (networkResponse == null) return;
                networkResponse.onError("url must begin with http:// or https://");
                return;
            }
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/json");
            connection.setConnectTimeout(5000);
            connection.connect();
            int status = connection.getResponseCode();
            switch (status) {
                case 200: 
                case 201: {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        response.append(line + "\n");
                    }
                    br.close();
                    if (networkResponse == null) return;
                    networkResponse.onResponse(response.toString());
                    return;
                }
                default: {
                    if (networkResponse == null) return;
                    networkResponse.onError("Invalid response code: " + status);
                    return;
                }
            }
        }
        catch (MalformedURLException e) {
            if (networkResponse == null) return;
            networkResponse.onError("MalformedURLException: " + e.getLocalizedMessage());
            return;
        }
        catch (IOException e) {
            if (networkResponse == null) return;
            networkResponse.onError("IOException: " + e.getLocalizedMessage());
            return;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

