/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android;

import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewTreeObserver;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class OnScrollChangedListenerImpl
implements ViewTreeObserver.OnScrollChangedListener {
    private WeakReference<View> mViewWeakReference;
    private List<ViewTreeObserver.OnScrollChangedListener> mChangedListeners = new ArrayList<ViewTreeObserver.OnScrollChangedListener>();

    public OnScrollChangedListenerImpl(View view) {
        if (this.mViewWeakReference == null || this.mViewWeakReference.get() == null) {
            this.mViewWeakReference = new WeakReference<View>(view);
            ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver != null) {
                viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            }
        }
    }

    public void addListener(@NonNull ViewTreeObserver.OnScrollChangedListener listener) {
        if (!this.mChangedListeners.contains(listener)) {
            this.mChangedListeners.add(listener);
        }
    }

    public void removeListener(ViewTreeObserver.OnScrollChangedListener listener) {
        if (listener != null) {
            this.mChangedListeners.remove(listener);
        }
    }

    public void onScrollChanged() {
        for (ViewTreeObserver.OnScrollChangedListener onScrollChangedListener : this.mChangedListeners) {
            onScrollChangedListener.onScrollChanged();
        }
    }

    public void clear() {
        if (this.mViewWeakReference != null && this.mViewWeakReference.get() != null) {
            ViewTreeObserver viewTreeObserver = ((View)this.mViewWeakReference.get()).getViewTreeObserver();
            if (viewTreeObserver != null) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            }
            this.mViewWeakReference.clear();
            this.mViewWeakReference = null;
        }
        this.mChangedListeners.clear();
    }
}

