/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import sunmi.sunmiui.R;

public class ErrorView
extends FrameLayout {
    private View mView;
    private ImageView imgError;
    private TextView textMsg;
    private TextView textT;

    public ErrorView(Context context) {
        super(context);
        this.init();
    }

    public ErrorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ErrorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mView = View.inflate((Context)this.getContext(), (int)R.layout.view_error, (ViewGroup)this);
        this.imgError = (ImageView)this.mView.findViewById(R.id.img_error);
        this.textMsg = (TextView)this.mView.findViewById(R.id.text_error);
        this.textT = (TextView)this.mView.findViewById(R.id.text_on);
    }

    public void setErrorTypr(ErroType erroType) {
        switch (erroType) {
            case NET_ERROR: {
                this.set(R.drawable.img_no_net, this.getContext().getString(R.string.net_error), this.getContext().getString(R.string.click_screen_try));
                break;
            }
            case SERVER_ERROR: {
                this.set(R.drawable.img_server_error, this.getContext().getString(R.string.server_error), this.getContext().getString(R.string.click_screen_try));
                break;
            }
            case NO_ORDER: {
                this.set(R.drawable.img_no_order, this.getContext().getString(R.string.no_order), "");
            }
        }
    }

    private void set(int drawable2, CharSequence errorMsg, CharSequence prompt) {
        this.imgError.setImageResource(drawable2);
        this.textMsg.setText(errorMsg);
        this.textT.setText(prompt);
    }

    public void setMsg(CharSequence errorMsg) {
        this.textMsg.setText(errorMsg);
    }

    public void setImgError(int drawable2) {
        this.imgError.setImageResource(drawable2);
    }

    public void setClickText(CharSequence prompt) {
        this.textT.setText(prompt);
    }

    public static enum ErroType {
        NET_ERROR,
        SERVER_ERROR,
        NO_ORDER;

    }
}

