/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.window;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.TextView;

public class VersionView {
    private Context mContext;
    private WindowManager windowManager;
    private WindowManager.LayoutParams windowParams;
    private TextView mText;
    private boolean isAdded = false;

    public VersionView(Context mContext) {
        this.mContext = mContext;
        this.initView();
    }

    private void initView() {
        this.mText = new TextView(this.mContext);
        this.mText.setText((CharSequence)"release");
        this.mText.setTextColor(Color.parseColor((String)"#ffffff"));
        this.mText.setWidth(80);
        this.mText.setHeight(50);
        this.mText.setGravity(17);
        this.mText.setBackgroundColor(Color.parseColor((String)"#cc000000"));
        if (this.windowManager == null) {
            this.setWindowParams(0, 0);
            this.windowManager = (WindowManager)this.mContext.getSystemService("window");
        }
    }

    public void showInfo(String info) {
        this.mText.setText((CharSequence)("" + info));
        if (!this.isAdded) {
            this.windowManager.addView((View)this.mText, (ViewGroup.LayoutParams)this.windowParams);
            this.isAdded = true;
        }
    }

    public void hide() {
        if (this.windowManager != null && this.mText != null && this.isAdded) {
            this.windowManager.removeView((View)this.mText);
            this.isAdded = false;
        }
    }

    private void setWindowParams(int x, int y) {
        this.windowParams = new WindowManager.LayoutParams();
        this.windowParams.gravity = 85;
        this.windowParams.x = x;
        this.windowParams.y = y;
        this.windowParams.width = 80;
        this.windowParams.height = 50;
        this.windowParams.flags = 408;
        this.windowParams.format = -3;
        this.windowParams.windowAnimations = 0;
    }
}

