/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.dialog;

import android.annotation.TargetApi;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import sunmi.sunmiui.R;
import sunmi.sunmiui.dialog.BaseDialog;
import sunmi.sunmiui.utils.Adaptation;
import sunmi.sunmiui.utils.LogUtil;

public class ListDialog
extends BaseDialog {
    private static ListDialog instance;
    private LinearLayout list;
    private ScrollView scrollView;
    private ItemClickListener itemClickListener;

    private ListDialog() {
    }

    public static ListDialog getInstance() {
        if (instance == null) {
            instance = new ListDialog();
        }
        return instance;
    }

    public void setItemClickListener(ItemClickListener listener) {
        this.itemClickListener = listener;
    }

    @Override
    @TargetApi(value=21)
    protected void init() {
        this.scrollView = (ScrollView)this.dialog.findViewById(R.id.scrollView);
        this.list = (LinearLayout)this.dialog.findViewById(R.id.list);
        View cancel = this.dialog.findViewById(R.id.btn_cancel);
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ListDialog.this.cancel();
            }
        });
    }

    @Override
    protected void onDialogCancel() {
        this.dialog = null;
        instance = null;
    }

    @TargetApi(value=16)
    public void setData(String[] items) {
        this.list.removeAllViews();
        float itemHeight = this.getHeight();
        LogUtil.d("ListDialog", itemHeight + "");
        ViewGroup.LayoutParams layoutParams = this.scrollView.getLayoutParams();
        int height = 0;
        int j = 0;
        for (int i = 0; i < items.length; ++i) {
            String itemStr = items[i];
            View view = this.inflatView();
            TextView text = (TextView)view.findViewById(R.id.text);
            text.setText((CharSequence)itemStr);
            view.setTag((Object)i);
            view.setOnClickListener((View.OnClickListener)new ItemClick());
            this.list.addView(view);
            if (i > 3) continue;
            height = (int)((float)height + itemHeight);
            j = i;
        }
        layoutParams.height = height + j + 1;
        this.scrollView.setLayoutParams(layoutParams);
    }

    private float getHeight() {
        switch (Adaptation.proportion) {
            case 1: {
                return this.resources.getDimension(R.dimen.itemHeight);
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                return this.resources.getDimension(R.dimen.itemHeightT1);
            }
        }
        return 0.0f;
    }

    private View inflatView() {
        switch (Adaptation.proportion) {
            case 1: {
                return View.inflate((Context)this.dialog.getContext(), (int)R.layout.item_text_9_16, null);
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                return View.inflate((Context)this.dialog.getContext(), (int)R.layout.item_text_16_9, null);
            }
        }
        return null;
    }

    public static interface ItemClickListener {
        public void OnItemClick(int var1);
    }

    class ItemClick
    implements View.OnClickListener {
        ItemClick() {
        }

        public void onClick(View view) {
            int pos = (Integer)view.getTag();
            if (ListDialog.this.itemClickListener != null) {
                ListDialog.this.itemClickListener.OnItemClick(pos);
            }
        }
    }
}

