/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.utils;

import android.app.Activity;
import android.app.Dialog;
import android.content.DialogInterface;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import sunmi.sunmiui.utils.LogUtil;

public class UIUtils {
    private static final int SYSTEM_UI_FLAG_SUN_MI_SEC = 8;

    private static void setSecStatusBar(View view) {
        int systemUiVisibility = view.getSystemUiVisibility();
        view.setSystemUiVisibility(systemUiVisibility |= 8);
    }

    private static void banPowerKey(Window window) {
        if (window != null) {
            window.setFlags(4, 4);
        }
    }

    private static void banVolumeKey(Dialog dialog) {
        dialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                String tag = "onKeyDown";
                if (keyCode == 25) {
                    LogUtil.e(tag, "KEYCODE_VOLUME_DOWN");
                    return true;
                }
                if (keyCode == 24) {
                    LogUtil.e(tag, "KEYCODE_VOLUME_UP");
                    return true;
                }
                return false;
            }
        });
    }

    public static void screenMonopoly(Window window) {
        UIUtils.banPowerKey(window);
        UIUtils.setSecStatusBar(window.getDecorView());
        window.addFlags(128);
    }

    public static void screenMonopoly(Dialog dialog) {
        Window window = dialog.getWindow();
        if (window != null) {
            window.addFlags(128);
            UIUtils.banPowerKey(window);
            UIUtils.setSecStatusBar(window.getDecorView());
            UIUtils.banVolumeKey(dialog);
        }
    }

    public static void setLight(Activity context, int brightness) {
        WindowManager.LayoutParams lp = context.getWindow().getAttributes();
        lp.screenBrightness = Float.valueOf(brightness).floatValue() * 0.003921569f;
        context.getWindow().setAttributes(lp);
    }
}

