/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.dialog;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import sunmi.sunmiui.R;
import sunmi.sunmiui.dialog.BaseDialog;
import sunmi.sunmiui.dialog.CodeInputSuccess;
import sunmi.sunmiui.utils.BitmapUtil;

public class CodeDialog
extends BaseDialog {
    private static CodeDialog instance;
    private TextView title;
    private TextView error;
    private ImageView code;
    private ImageView clear;
    private ImageView load;
    private EditText editText;
    private boolean isReq;

    public static CodeDialog getInstance() {
        if (instance == null) {
            instance = new CodeDialog();
        }
        return instance;
    }

    @Override
    protected void init() {
        this.title = (TextView)this.dialog.findViewById(R.id.txt);
        this.code = (ImageView)this.dialog.findViewById(R.id.code);
        this.editText = (EditText)this.dialog.findViewById(R.id.editText);
        this.clear = (ImageView)this.dialog.findViewById(R.id.clear);
        this.load = (ImageView)this.dialog.findViewById(R.id.load);
        this.error = (TextView)this.dialog.findViewById(R.id.txt_error);
        this.clear.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CodeDialog.this.editText.setText((CharSequence)"");
            }
        });
        this.error.setVisibility(8);
        this.load.setVisibility(8);
        this.clear.setVisibility(8);
    }

    public void setData(String titleString, String imgBase64, final CodeInputSuccess listener, View.OnClickListener incodeOnClickListener) {
        this.isReq = false;
        this.error.setVisibility(8);
        this.load.clearAnimation();
        this.load.setVisibility(8);
        this.clear.setVisibility(8);
        this.title.setText((CharSequence)titleString);
        this.code.setImageBitmap(BitmapUtil.stringtoBitmap(imgBase64));
        this.code.setOnClickListener(incodeOnClickListener);
        this.editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (s.length() > 0 && !CodeDialog.this.isReq) {
                    CodeDialog.this.load.clearAnimation();
                    CodeDialog.this.load.setVisibility(8);
                    CodeDialog.this.clear.setVisibility(0);
                }
                if (listener != null && s.length() == 4 && !CodeDialog.this.isReq) {
                    listener.codeInputSuccess(s.toString());
                }
                if (s.length() == 0 && !CodeDialog.this.isReq) {
                    CodeDialog.this.load.clearAnimation();
                    CodeDialog.this.load.setVisibility(8);
                    CodeDialog.this.clear.setVisibility(8);
                }
            }
        });
    }

    public void setImgCode(String imgBase64) {
        this.isReq = false;
        this.code.setImageBitmap(BitmapUtil.stringtoBitmap(imgBase64));
        this.load.clearAnimation();
        this.load.setVisibility(8);
        this.clear.setVisibility(8);
    }

    public void showError(String msg) {
        this.error.setText((CharSequence)msg);
        this.error.setVisibility(0);
        this.load.clearAnimation();
        this.load.setVisibility(8);
        this.clear.setVisibility(8);
        this.editText.setText((CharSequence)"");
    }

    public void hideError() {
        this.error.setVisibility(8);
    }

    public void hideLoad() {
        this.isReq = false;
        this.load.clearAnimation();
        this.load.setVisibility(8);
    }

    public void showLoad() {
        this.isReq = true;
        this.load.setVisibility(0);
        this.clear.setVisibility(8);
        Animation operatingAnim = AnimationUtils.loadAnimation((Context)this.dialog.getContext(), (int)R.anim.loading_anim);
        LinearInterpolator lin = new LinearInterpolator();
        operatingAnim.setInterpolator((Interpolator)lin);
        this.load.setAnimation(operatingAnim);
        this.load.startAnimation(operatingAnim);
    }

    @Override
    public void dismiss() {
        super.dismiss();
    }

    @Override
    protected void onDialogCancel() {
        this.load.clearAnimation();
    }
}

