/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.dialog;

import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.text.method.KeyListener;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import sunmi.sunmiui.R;
import sunmi.sunmiui.dialog.BaseEditDialog;

public class EditTextDialog
extends BaseEditDialog {
    private static EditTextDialog instance;
    private View clear;
    TextWatcher textWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void onTextChanged(CharSequence charSequence, int start, int count, int after) {
        }

        public void afterTextChanged(Editable editable) {
            if (editable.length() > 0) {
                EditTextDialog.this.clear.setVisibility(0);
            } else {
                EditTextDialog.this.clear.setVisibility(4);
            }
        }
    };

    private EditTextDialog() {
    }

    public static EditTextDialog getInstance() {
        if (instance == null) {
            instance = new EditTextDialog();
        }
        return instance;
    }

    @Override
    protected void init() {
        this.editText = (EditText)this.dialog.findViewById(R.id.edit);
        this.clear = this.dialog.findViewById(R.id.clear);
        this.editText.addTextChangedListener(this.textWatcher);
        this.clear.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                EditTextDialog.this.editText.setText((CharSequence)"");
            }
        });
    }

    @Override
    protected void onDialogCancel() {
        this.editText.setText((CharSequence)"");
        instance = null;
    }

    public void showKeyboard() {
        if (this.editText != null) {
            this.editText.setFocusable(true);
            this.editText.setFocusableInTouchMode(true);
            this.editText.requestFocus();
            InputMethodManager inputManager = (InputMethodManager)this.editText.getContext().getSystemService("input_method");
            inputManager.showSoftInput((View)this.editText, 0);
        }
    }

    public void setText(String content) {
        this.editText.setText((CharSequence)content);
        this.editText.setSelection(content.length());
    }

    public void setMaxLength(int num) {
        this.editText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(num)});
    }

    public void setHintText(String text) {
        this.editText.setHint((CharSequence)text);
    }

    public void setKeyListen(KeyListener listen) {
        this.editText.setKeyListener(listen);
    }
}

