/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import sunmi.sunmiui.R;
import sunmi.sunmiui.utils.Adaptation;

public class LoadView
extends FrameLayout {
    private View mView;
    private TextView mText;
    private ImageView img;

    public LoadView(Context context) {
        super(context);
        this.init();
    }

    public LoadView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LoadView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mView = this.getView();
        this.mText = (TextView)this.mView.findViewById(R.id.txt);
        this.img = (ImageView)this.mView.findViewById(R.id.img);
        Animation operatingAnim = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.loading_anim);
        LinearInterpolator lin = new LinearInterpolator();
        operatingAnim.setInterpolator((Interpolator)lin);
        this.img.setAnimation(operatingAnim);
        this.img.startAnimation(operatingAnim);
    }

    private View getView() {
        switch (Adaptation.proportion) {
            case 1: {
                return View.inflate((Context)this.getContext(), (int)R.layout.view_load_9_16, (ViewGroup)this);
            }
            case 2: {
                return View.inflate((Context)this.getContext(), (int)R.layout.view_load_9_16, (ViewGroup)this);
            }
            case 3: {
                return View.inflate((Context)this.getContext(), (int)R.layout.view_load_16_9, (ViewGroup)this);
            }
            case 4: {
                return View.inflate((Context)this.getContext(), (int)R.layout.view_load_16_9, (ViewGroup)this);
            }
        }
        return View.inflate((Context)this.getContext(), (int)R.layout.view_load_9_16, (ViewGroup)this);
    }

    public void setText(CharSequence text) {
        this.mText.setText(text);
    }
}

