/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import sunmi.sunmiui.R;
import sunmi.sunmiui.dialog.CodeDialog;
import sunmi.sunmiui.dialog.EditPwdDialog;
import sunmi.sunmiui.dialog.EditTextDialog;
import sunmi.sunmiui.dialog.HintDialog;
import sunmi.sunmiui.dialog.HintOneBtnDialog;
import sunmi.sunmiui.dialog.ListDialog;
import sunmi.sunmiui.dialog.LoadingDialog;
import sunmi.sunmiui.dialog.TextHintDialog;
import sunmi.sunmiui.utils.Adaptation;

public class DialogCreater {
    public static HintDialog createHintDialog(Context context, int iconId, String textLeft, String textRight, String message, View.OnClickListener left, View.OnClickListener right, boolean isSystem) {
        HintDialog dialogProxy = HintDialog.getInstance();
        if (dialogProxy.hasDialog()) {
            return dialogProxy;
        }
        Dialog dialog = DialogCreater.setHintDialogContentView(context);
        ImageView img = (ImageView)dialog.findViewById(R.id.img);
        img.setImageResource(iconId);
        TextView tvMsg = (TextView)dialog.findViewById(R.id.content);
        TextView btnLeft = (TextView)dialog.findViewById(R.id.left);
        TextView btnRight = (TextView)dialog.findViewById(R.id.right);
        tvMsg.setText((CharSequence)message);
        btnLeft.setText((CharSequence)textLeft);
        btnLeft.setOnClickListener(left);
        if (isSystem) {
            dialogProxy.setSystemDialog(dialog);
        } else {
            dialogProxy.setDialog(dialog);
        }
        View line = dialog.findViewById(R.id.line2);
        if (TextUtils.isEmpty((CharSequence)textRight)) {
            btnRight.setVisibility(8);
            line.setVisibility(8);
            if (Adaptation.proportion == 1) {
                btnLeft.setBackgroundResource(R.drawable.ripple_bg_bottom);
            } else if (Adaptation.proportion == 4) {
                btnLeft.setBackgroundResource(R.drawable.ripple_bg_bottom_t1);
            }
            btnLeft.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 2.0f));
        } else {
            btnRight.setVisibility(0);
            line.setVisibility(0);
            if (Adaptation.proportion == 1) {
                btnLeft.setBackgroundResource(R.drawable.ripple_bg_left_bottom);
            } else if (Adaptation.proportion == 4) {
                btnLeft.setBackgroundResource(R.drawable.ripple_bg_left_bottom_t1);
            }
            btnRight.setText((CharSequence)textRight);
            btnRight.setOnClickListener(right);
        }
        return dialogProxy;
    }

    public static TextHintDialog createTextHintDialog(Context context, String title, String textLeft, String textRight, String message, View.OnClickListener left, View.OnClickListener right, boolean isSystem) {
        TextHintDialog dialogProxy = TextHintDialog.getInstance();
        if (dialogProxy.hasDialog()) {
            return dialogProxy;
        }
        Dialog dialog = DialogCreater.setTextHintDialogContentView(context);
        TextView tvTitle = (TextView)dialog.findViewById(R.id.dialog_title);
        TextView tvMsg = (TextView)dialog.findViewById(R.id.dialog_msg);
        TextView btnLeft = (TextView)dialog.findViewById(R.id.left);
        TextView btnRight = (TextView)dialog.findViewById(R.id.right);
        tvTitle.setText((CharSequence)title);
        tvMsg.setText((CharSequence)message);
        btnLeft.setText((CharSequence)textLeft);
        btnLeft.setOnClickListener(left);
        if (isSystem) {
            dialogProxy.setSystemDialog(dialog);
        } else {
            dialogProxy.setDialog(dialog);
        }
        View line = dialog.findViewById(R.id.line_view);
        if (TextUtils.isEmpty((CharSequence)textRight)) {
            btnRight.setVisibility(8);
            line.setVisibility(8);
            if (Adaptation.proportion == 1) {
                btnLeft.setBackgroundResource(R.drawable.ripple_bg_bottom);
            } else if (Adaptation.proportion == 4) {
                btnLeft.setBackgroundResource(R.drawable.ripple_bg_bottom_t1);
            }
            btnLeft.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 2.0f));
        } else {
            btnRight.setVisibility(0);
            line.setVisibility(0);
            if (Adaptation.proportion == 1) {
                btnLeft.setBackgroundResource(R.drawable.ripple_bg_left_bottom);
            } else if (Adaptation.proportion == 4) {
                btnLeft.setBackgroundResource(R.drawable.ripple_bg_left_bottom_t1);
            }
            btnRight.setText((CharSequence)textRight);
            btnRight.setOnClickListener(right);
        }
        return dialogProxy;
    }

    public static EditTextDialog createEditTextDialog(Context context, String textLeft, String textRight, String title, View.OnClickListener left, View.OnClickListener right) {
        EditTextDialog dialogProxy = EditTextDialog.getInstance();
        if (dialogProxy.hasDialog()) {
            return dialogProxy;
        }
        Dialog dialog = DialogCreater.setEditTextDialogContentView(context);
        TextView tvMsg = (TextView)dialog.findViewById(R.id.title);
        TextView btnLeft = (TextView)dialog.findViewById(R.id.left);
        TextView btnRight = (TextView)dialog.findViewById(R.id.right);
        tvMsg.setText((CharSequence)title);
        btnLeft.setText((CharSequence)textLeft);
        btnRight.setText((CharSequence)textRight);
        btnLeft.setOnClickListener(left);
        btnRight.setOnClickListener(right);
        dialog.findViewById(R.id.clear).setVisibility(4);
        dialogProxy.setDialog(dialog);
        return dialogProxy;
    }

    public static EditPwdDialog createEditPwdDialog(Context context, String textLeft, String textRight, String title, View.OnClickListener left, View.OnClickListener right) {
        EditPwdDialog dialogProxy = EditPwdDialog.getInstance();
        if (dialogProxy.hasDialog()) {
            return dialogProxy;
        }
        Dialog dialog = DialogCreater.setEditPwdDialogContentView(context);
        TextView tvMsg = (TextView)dialog.findViewById(R.id.title);
        TextView btnLeft = (TextView)dialog.findViewById(R.id.left);
        TextView btnRight = (TextView)dialog.findViewById(R.id.right);
        tvMsg.setText((CharSequence)title);
        btnLeft.setText((CharSequence)textLeft);
        btnRight.setText((CharSequence)textRight);
        btnLeft.setOnClickListener(left);
        btnRight.setOnClickListener(right);
        dialogProxy.setDialog(dialog);
        return dialogProxy;
    }

    public static ListDialog createListDialog(Context context, String title, String cancel, String[] items) {
        ListDialog dialogProxy = ListDialog.getInstance();
        if (dialogProxy.hasDialog()) {
            return dialogProxy;
        }
        Dialog dialog = DialogCreater.setListDialogContentView(context);
        TextView tvMsg = (TextView)dialog.findViewById(R.id.title);
        tvMsg.setText((CharSequence)title);
        TextView tvCancel = (TextView)dialog.findViewById(R.id.btn_cancel);
        tvCancel.setText((CharSequence)cancel);
        dialogProxy.setDialog(dialog);
        dialogProxy.setData(items);
        return dialogProxy;
    }

    public static LoadingDialog createLoadingDialog(Context context, String msg) {
        LoadingDialog dialogProxy = LoadingDialog.getInstance();
        if (dialogProxy.hasDialog()) {
            return dialogProxy;
        }
        Dialog dialog = DialogCreater.setLoadingDialogContentView(context);
        TextView tvMsg = (TextView)dialog.findViewById(R.id.msg);
        tvMsg.setText((CharSequence)msg);
        dialogProxy.setDialog(dialog);
        return dialogProxy;
    }

    public static HintOneBtnDialog createHintOneBtnDialog(Context context, String head, String msg, String cancel, View.OnClickListener cancelClickListener) {
        HintOneBtnDialog hintOneBtnDialog = HintOneBtnDialog.getInstance();
        if (hintOneBtnDialog.hasDialog()) {
            return hintOneBtnDialog;
        }
        Dialog dialog = DialogCreater.setHintOneBtnDialogContentView(context);
        TextView head1 = (TextView)dialog.findViewById(R.id.head);
        TextView msg1 = (TextView)dialog.findViewById(R.id.msg);
        TextView btn = (TextView)dialog.findViewById(R.id.btnTxt);
        if (TextUtils.isEmpty((CharSequence)head)) {
            head1.setVisibility(8);
        } else {
            head1.setVisibility(0);
            head1.setText((CharSequence)head);
        }
        if (TextUtils.isEmpty((CharSequence)msg)) {
            msg1.setVisibility(8);
        } else {
            msg1.setVisibility(0);
            msg1.setText((CharSequence)msg);
        }
        if (TextUtils.isEmpty((CharSequence)cancel)) {
            btn.setVisibility(8);
        } else {
            btn.setVisibility(0);
            btn.setText((CharSequence)cancel);
        }
        btn.setOnClickListener(cancelClickListener);
        hintOneBtnDialog.setDialog(dialog);
        return hintOneBtnDialog;
    }

    private static Dialog setHintOneBtnDialogContentView(Context context) {
        switch (Adaptation.proportion) {
            case 1: {
                String model = Build.MODEL;
                if (model.contains("m1") || model.contains("M1")) {
                    return DialogCreater.getDialog(context, R.layout.dialog_hint_one_btn_9_16_m1);
                }
                return DialogCreater.getDialog(context, R.layout.dialog_hint_one_btn_9_16);
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                return DialogCreater.getDialog(context, R.layout.dialog_hint_one_btn_16_9);
            }
            default: {
                return DialogCreater.getDialog(context, R.layout.dialog_hint_one_btn_16_9);
            }
        }
        return null;
    }

    public static CodeDialog createCodeDialog(Context context) {
        CodeDialog codeDialog = CodeDialog.getInstance();
        if (codeDialog.hasDialog()) {
            return codeDialog;
        }
        Dialog dialog = DialogCreater.setCodeDialogContentView(context);
        codeDialog.setDialog(dialog);
        return codeDialog;
    }

    private static Dialog setCodeDialogContentView(Context context) {
        switch (Adaptation.proportion) {
            case 1: {
                String model = Build.MODEL;
                if (model.contains("M1") || model.contains("m1")) {
                    return DialogCreater.getDialog(context, R.layout.dialog_code_9_16_m1);
                }
                return DialogCreater.getDialog(context, R.layout.dialog_code_9_16);
            }
            case 2: {
                return DialogCreater.getDialog(context, R.layout.dialog_code_9_16);
            }
            case 3: {
                return DialogCreater.getDialog(context, R.layout.dialog_code_16_9);
            }
            case 4: {
                return DialogCreater.getDialog(context, R.layout.dialog_code_16_9);
            }
        }
        return DialogCreater.getDialog(context, R.layout.dialog_code_9_16);
    }

    private static Dialog getDialog(Context context, int layoutId) {
        Dialog dialog = new Dialog(context, R.style.defaultDialogStyle);
        dialog.setContentView(layoutId);
        dialog.getWindow().getAttributes().gravity = 17;
        dialog.setCanceledOnTouchOutside(true);
        dialog.setCancelable(false);
        return dialog;
    }

    private static Dialog setEditPwdDialogContentView(Context context) {
        switch (Adaptation.proportion) {
            case 1: {
                String model = Build.MODEL;
                if (model.contains("M1") || model.equals("m1")) {
                    return DialogCreater.getDialog(context, R.layout.dialog_edit_pwd_9_16_m1);
                }
                return DialogCreater.getDialog(context, R.layout.dialog_edit_pwd_9_16);
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                return DialogCreater.getDialog(context, R.layout.dialog_edit_pwd_16_9);
            }
        }
        return null;
    }

    private static Dialog setEditTextDialogContentView(Context context) {
        switch (Adaptation.proportion) {
            case 1: {
                String model = Build.MODEL;
                if (model.contains("m1") || model.contains("M1")) {
                    return DialogCreater.getDialog(context, R.layout.dialog_edit_text_9_16_m1);
                }
                return DialogCreater.getDialog(context, R.layout.dialog_edit_text_9_16);
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                return DialogCreater.getDialog(context, R.layout.dialog_edit_text_16_9);
            }
        }
        return null;
    }

    private static Dialog setListDialogContentView(Context context) {
        switch (Adaptation.proportion) {
            case 1: {
                return DialogCreater.getDialog(context, R.layout.dialog_item_select_9_16);
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                return DialogCreater.getDialog(context, R.layout.dialog_item_select_16_9);
            }
        }
        return null;
    }

    private static Dialog setLoadingDialogContentView(Context context) {
        switch (Adaptation.proportion) {
            case 1: {
                return DialogCreater.getDialog(context, R.layout.dialog_loading_9_16);
            }
            case 2: {
                return DialogCreater.getDialog(context, R.layout.dialog_loading_9_16);
            }
            case 3: {
                return DialogCreater.getDialog(context, R.layout.dialog_loading_16_9);
            }
            case 4: {
                return DialogCreater.getDialog(context, R.layout.dialog_loading_16_9);
            }
        }
        return DialogCreater.getDialog(context, R.layout.dialog_loading_9_16);
    }

    private static Dialog setHintDialogContentView(Context context) {
        switch (Adaptation.proportion) {
            case 1: {
                String model = Build.MODEL;
                if (model.contains("M1") || model.contains("m1")) {
                    return DialogCreater.getDialog(context, R.layout.dialog_hint_9_16_m1);
                }
                return DialogCreater.getDialog(context, R.layout.dialog_hint_9_16);
            }
            case 2: {
                return DialogCreater.getDialog(context, R.layout.dialog_hint_9_16);
            }
            case 4: {
                return DialogCreater.getDialog(context, R.layout.dialog_hint_16_9);
            }
            case 3: {
                return DialogCreater.getDialog(context, R.layout.dialog_hint_16_9);
            }
        }
        return DialogCreater.getDialog(context, R.layout.dialog_hint_9_16);
    }

    private static Dialog setTextHintDialogContentView(Context context) {
        switch (Adaptation.proportion) {
            case 1: {
                String modle = Build.MODEL;
                if (modle.contains("m1") || modle.contains("M1")) {
                    return DialogCreater.getDialog(context, R.layout.dialog_text_hint_9_16_m1);
                }
                return DialogCreater.getDialog(context, R.layout.dialog_text_hint_9_16);
            }
            case 2: {
                return DialogCreater.getDialog(context, R.layout.dialog_text_hint_9_16);
            }
            case 3: {
                return DialogCreater.getDialog(context, R.layout.dialog_text_hint_4_3);
            }
            case 4: {
                return DialogCreater.getDialog(context, R.layout.dialog_text_hint_4_3);
            }
        }
        return DialogCreater.getDialog(context, R.layout.dialog_text_hint_9_16);
    }
}

