/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.banner;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.ViewConfigurationCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.Scroller;
import com.makeramen.roundedimageview.RoundedImageView;
import java.util.ArrayList;
import java.util.List;
import sunmi.sunmiui.R;
import sunmi.sunmiui.banner.Banner;
import sunmi.sunmiui.banner.Looper;
import sunmi.sunmiui.banner.State;
import sunmi.sunmiui.utils.LogUtil;

public class BannerLayout
extends ViewGroup {
    private static final String TAG = "BannerLayout";
    private static final String TAG1 = "BannerLayout1";
    private static final String TAG2 = "BannerLayout2";
    private int mSize = 4;
    private int mInterval = 0;
    private int firstMarginLeft = 0;
    private int mChildWidth = 1250;
    private int mChildHeight = 340;
    private int flipValue = this.mChildWidth / 3;
    private Scroller mScroller;
    private float mLastScrollX;
    private int mTouchSlop;
    private float mXDownView;
    private float mXDown;
    private float mXMove;
    private float mXLastMove;
    private VelocityTracker mVelocityTracker;
    private final float mflipXVelocity = 1400.0f;
    private float mLastXVelocity;
    private Looper looper;
    private OnPageShowListener mOnPageShowListener;
    private OnItemClickListener mOnItemClickListener;
    View.OnClickListener viewClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            Integer position = (Integer)view.getTag();
            List<Banner> bannerList = ((BannerLayout)BannerLayout.this).looper.bannerList;
            Banner b = BannerLayout.this.looper.get(position);
            LogUtil.d(BannerLayout.TAG, "onClick pos:" + b.position);
            if (BannerLayout.this.looper.bannerClick(b)) {
                LogUtil.d(BannerLayout.TAG, "onItemClick pos:" + b.position);
                if (BannerLayout.this.mOnItemClickListener != null) {
                    BannerLayout.this.mOnItemClickListener.onItemClick(view, b.position);
                }
            }
        }
    };
    Runnable changeRunningMan = new Runnable(){

        @Override
        public void run() {
            LogUtil.d(BannerLayout.TAG1, "pre changeRunningManOnScrollFinished mLastScrollX:" + BannerLayout.this.mLastScrollX + " mChildWidth/2=" + BannerLayout.this.mChildWidth / 2);
            if (BannerLayout.this.mLastScrollX > (float)BannerLayout.this.flipValue || BannerLayout.this.mLastXVelocity > 1400.0f) {
                BannerLayout.this.notifyOnPageShow();
                LogUtil.d(BannerLayout.TAG1, "changeRunningManOnScrollFinished run");
                BannerLayout.this.looper.changeRunningManOnScrollFinished();
            }
        }
    };
    Runnable reStart = new Runnable(){

        @Override
        public void run() {
            BannerLayout.this.looper.start();
        }
    };

    public BannerLayout(Context context) {
        super(context);
        this.init(null, 0);
    }

    public BannerLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public BannerLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
        LogUtil.setLevel(6);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BannerLayout, defStyle, 0);
        this.mSize = a.getInt(R.styleable.BannerLayout_size, this.mSize);
        this.mChildWidth = a.getInt(R.styleable.BannerLayout_childWidth, this.mChildWidth);
        this.mChildHeight = a.getInt(R.styleable.BannerLayout_childHeight, this.mChildHeight);
        this.flipValue = this.mChildWidth / 3;
        a.recycle();
        this.looper = new Looper(this);
        this.mScroller = new Scroller(this.getContext());
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop((ViewConfiguration)configuration);
        this.invalidateParams();
    }

    void invalidateParams() {
        this.stop();
        this.removeAllViews();
        this.looper.clear();
        for (int i = 0; i < this.mSize; ++i) {
            RoundedImageView view = new RoundedImageView(this.getContext());
            if (i != 0) {
                view.setBackgroundResource(R.drawable.drop_shadow);
                view.setPadding(0, 0, 15, 0);
            }
            view.setScaleType(ImageView.ScaleType.FIT_XY);
            view.setCornerRadius(10.0f);
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(this.mChildWidth, this.mChildHeight);
            view.setLayoutParams(params);
            this.addView((View)view);
            Banner banner = new Banner();
            banner.view = view;
            banner.position = i;
            this.looper.add(banner);
            view.setTag((Object)i);
            view.setOnClickListener(this.viewClickListener);
        }
        LogUtil.d(TAG, "invalidateParams");
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = 0; i < this.getChildCount(); ++i) {
            ImageView child = (ImageView)this.getChildAt(i);
            child.setEnabled(enabled);
        }
    }

    private void abortAnimation() {
        this.looper.stop();
        this.mScroller.abortAnimation();
        this.removeCallbacks(this.changeRunningMan);
        this.removeCallbacks(this.reStart);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.getParent().requestDisallowInterceptTouchEvent(true);
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.acquireVelocityTracker(ev);
        switch (ev.getAction()) {
            case 0: {
                LogUtil.d(TAG, "onInterceptTouchEvent ACTION_DOWN");
                Banner banner = this.looper.runningMan;
                if (banner != null) {
                    ImageView view = banner.view;
                    this.mXDownView = view.getX();
                    LogUtil.d(TAG1, "ACTION_DOWN: getX" + view.getX() + " view.getTranslationX" + view.getTranslationX() + " getScrollX:" + view.getScrollX());
                }
                this.mXLastMove = this.mXDown = ev.getRawX();
                this.abortAnimation();
                break;
            }
            case 2: {
                LogUtil.d(TAG, "onInterceptTouchEvent ACTION_MOVE");
                this.mXMove = ev.getRawX();
                float diff = Math.abs(this.mXMove - this.mXDown);
                this.mXLastMove = this.mXMove;
                if (!(diff > (float)this.mTouchSlop)) break;
                LogUtil.d(TAG, "diff > mTouchSlop diff:" + diff + " mTouchSlop:" + this.mTouchSlop);
                return true;
            }
            case 1: {
                LogUtil.d(TAG, "onInterceptTouchEvent ACTION_UP");
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mSize == 1) {
            LogUtil.d(TAG, "onTouchEvent mSize == 1");
            return true;
        }
        this.acquireVelocityTracker(event);
        Banner banner = this.looper.runningMan;
        ImageView bannerView = banner.view;
        LogUtil.d(TAG, "onTouchEvent runningMan pos:" + banner.position);
        switch (event.getAction()) {
            case 0: {
                LogUtil.d(TAG, "onTouchEvent ACTION_DOWN");
                break;
            }
            case 2: {
                LogUtil.d(TAG, "onTouchEvent ACTION_MOVE");
                if (!this.actionMove(event, banner)) break;
                return true;
            }
            case 1: {
                LogUtil.d(TAG, "onTouchEvent ACTION_UP");
                this.actionUp(banner);
                break;
            }
            case 3: {
                this.releaseVelocityTracker();
            }
        }
        return true;
    }

    public void computeScroll() {
        LogUtil.d(TAG1, "computeScroll");
        if (this.looper.runningMan == null) {
            return;
        }
        Banner banner = this.looper.runningMan;
        ImageView bannerView = banner.view;
        if (this.mScroller.computeScrollOffset()) {
            LogUtil.d(TAG1, "computeScrollOffset mScroller.getCurrX():" + this.mScroller.getCurrX() + " banner.exitEndX:" + banner.exitEndX);
            bannerView.setX((float)this.mScroller.getCurrX());
            this.invalidate();
            LogUtil.d(TAG1, "computeScrollOffset bannerView.getX():" + bannerView.getX() + " bannerView.getTranslationX():" + bannerView.getTranslationX());
            this.removeCallbacks(this.changeRunningMan);
            this.postDelayed(this.changeRunningMan, 100L);
            this.removeCallbacks(this.reStart);
            if (banner.isEntered() || banner.isExited()) {
                this.postDelayed(this.reStart, Banner.DELAY);
            } else {
                this.postDelayed(this.reStart, 100L);
            }
        }
    }

    protected synchronized void notifyOnPageShow() {
        if (this.mOnPageShowListener != null) {
            this.mOnPageShowListener.onPageShow(this.getShowingPosition());
        }
    }

    private boolean actionMove(MotionEvent event, Banner banner) {
        ImageView bannerView = banner.view;
        this.mXMove = event.getRawX();
        int scrolledX = (int)(this.mXLastMove - this.mXMove);
        Banner bannerNew = this.looper.changeRunningManByScrollDirection(scrolledX);
        if (banner.position != bannerNew.position) {
            banner = bannerNew;
            bannerView = banner.view;
            this.mXDownView = bannerView.getX();
        }
        LogUtil.d(TAG, "onTouchEvent scrolledX:" + scrolledX + " bannerView.getScrollX():" + bannerView.getScrollX() + " banner.exitEndX:" + banner.exitEndX + " banner.enterEndX:" + banner.enterEndX + " bannerView.getWidth():" + bannerView.getWidth());
        LogUtil.d(TAG, "onTouchEvent bannerView.getTranslationX():" + bannerView.getTranslationX() + " bannerView.getX():" + bannerView.getX());
        if (bannerView.getX() - (float)scrolledX < (float)banner.exitEndX) {
            bannerView.setX((float)banner.exitEndX);
            return true;
        }
        if (bannerView.getX() - (float)scrolledX > (float)banner.enterEndX) {
            bannerView.setX((float)banner.enterEndX);
            return true;
        }
        LogUtil.d(TAG, "\u6ed1\u52a8 bannerView.offsetLeftAndRight:" + -scrolledX);
        bannerView.offsetLeftAndRight(-scrolledX);
        LogUtil.d(TAG1, " bannerView.getScrollX():" + bannerView.getScrollX() + " bannerView.getTranslationX():" + bannerView.getTranslationX() + " bannerView.getX():" + bannerView.getX() + " bannerView.getLeft():" + bannerView.getLeft());
        this.mXLastMove = this.mXMove;
        return false;
    }

    private void actionUp(Banner banner) {
        ImageView bannerView = banner.view;
        this.mVelocityTracker.computeCurrentVelocity(1000);
        float xVelocity = this.mVelocityTracker.getXVelocity();
        LogUtil.d(TAG2, "the x velocity is " + this.mVelocityTracker.getXVelocity());
        int dx = 0;
        float scrollX = (int)(this.mXLastMove - this.mXDown);
        float absScrollX = Math.abs(scrollX);
        int flipValue = this.flipValue;
        if (this.mXDownView == (float)banner.enterEndX || State.Entering.equals((Object)banner.getState())) {
            if (absScrollX >= (float)flipValue || xVelocity < -1400.0f) {
                dx = (int)((float)banner.exitEndX - bannerView.getX());
                banner.setState(State.Exiting);
            } else if (absScrollX < (float)flipValue) {
                dx = (int)((float)banner.enterEndX - bannerView.getX());
                banner.setState(State.Entering);
            }
        } else if (this.mXDownView == (float)banner.exitEndX || State.Exiting.equals((Object)banner.getState())) {
            if (absScrollX >= (float)flipValue || xVelocity > 1400.0f) {
                dx = (int)((float)banner.enterEndX - bannerView.getX());
                banner.setState(State.Entering);
            } else if (absScrollX < (float)flipValue) {
                dx = (int)((float)banner.exitEndX - bannerView.getX());
                banner.setState(State.Exiting);
            }
        }
        this.mLastScrollX = absScrollX;
        this.mLastXVelocity = Math.abs(xVelocity);
        LogUtil.d(TAG, "ACTION_UP dx:" + dx + " bannerView.getScrollX():" + bannerView.getScrollX() + " bannerView.getTranslationX():" + bannerView.getTranslationX() + " bannerView.getX():" + bannerView.getX());
        this.mScroller.startScroll((int)bannerView.getX(), 0, dx, 0);
        this.invalidate();
        this.releaseVelocityTracker();
    }

    private void acquireVelocityTracker(MotionEvent event) {
        if (null == this.mVelocityTracker) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
    }

    private void releaseVelocityTracker() {
        if (null != this.mVelocityTracker) {
            this.mVelocityTracker.clear();
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    public List<ImageView> getAllImageView() {
        ArrayList<ImageView> list = new ArrayList<ImageView>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            ImageView child = (ImageView)this.getChildAt(i);
            list.add(child);
        }
        return list;
    }

    public int getSize() {
        return this.mSize;
    }

    public void setSize(int size) {
        this.mSize = size;
        this.invalidateParams();
    }

    public int getInterval() {
        return this.mInterval;
    }

    public int getChildWidth() {
        return this.mChildWidth;
    }

    public void setChildWidth(int width) {
        this.mChildWidth = width;
        this.invalidateParams();
    }

    public int getChildHeight() {
        return this.mChildHeight;
    }

    public void setChildHeight(int height) {
        this.mChildHeight = height;
        this.invalidateParams();
    }

    public synchronized int getShowingPosition() {
        Banner showingBanner = this.looper.getShowingBanner();
        if (showingBanner == null) {
            return this.getChildCount() - 1;
        }
        return showingBanner.position;
    }

    public void stop() {
        if (this.mSize == 1) {
            return;
        }
        this.abortAnimation();
    }

    public void start() {
        if (this.mSize == 1) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                BannerLayout.this.looper.start();
            }
        });
    }

    public void setBannerDisplayDuration(int duration) {
        Banner.DELAY = duration;
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    public void setOnPageShowListener(OnPageShowListener listener) {
        this.mOnPageShowListener = listener;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) == 0) {
            throw new RuntimeException("BannerLayout: child MeasureSpec mode undefined!");
        }
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mChildHeight, (int)0x40000000);
        this.firstMarginLeft = width - this.mChildWidth;
        if (this.mSize - 1 > 0) {
            this.mInterval = (width - this.mChildWidth) / (this.mSize - 1);
        } else if (this.mSize - 1 == 0) {
            this.mInterval = 0;
            this.firstMarginLeft = 0;
            View child = this.getChildAt(0);
            if (child != null) {
                ViewGroup.LayoutParams lp = child.getLayoutParams();
                lp.width = width;
                lp.height = this.mChildHeight;
                child.setLayoutParams(lp);
                int wSpec = View.MeasureSpec.makeMeasureSpec((int)lp.width, (int)0x40000000);
                int hSpec = View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)0x40000000);
                child.measure(wSpec, hSpec);
            }
        }
        if (this.mSize > 1) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (child.getVisibility() == 8) continue;
                ViewGroup.LayoutParams lp = child.getLayoutParams();
                int wSpec = View.MeasureSpec.makeMeasureSpec((int)lp.width, (int)0x40000000);
                int hSpec = View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)0x40000000);
                child.measure(wSpec, hSpec);
            }
        }
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        LogUtil.d(TAG, "onLayout");
        int count = this.getChildCount();
        int xpos = this.getPaddingLeft() + this.firstMarginLeft;
        int ypos = this.getPaddingTop();
        if (count == 1) {
            View child = this.getChildAt(0);
            child.layout(xpos, ypos, xpos + this.getWidth(), this.getHeight());
            Banner banner = this.looper.get(0);
            banner.enterEndX = xpos;
            banner.exitEndX = xpos;
            return;
        }
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.layout(xpos, ypos, xpos + this.mChildWidth, ypos + this.mChildHeight);
            Banner banner = this.looper.get(i);
            banner.enterEndX = xpos;
            banner.exitEndX = xpos - child.getWidth() + this.mInterval + 35;
            if (i == 0) {
                banner.exitEndX = xpos;
                banner.nextEnter = this.looper.get(1);
                banner.nextExit = this.looper.get(this.getChildCount() - 1);
            }
            LogUtil.d(TAG, "child position:" + banner.position + " banner.enterEndX:" + banner.enterEndX + " banner.exitEndX:" + banner.exitEndX);
            xpos -= this.mInterval;
        }
    }

    public static interface OnPageShowListener {
        public void onPageShow(int var1);
    }

    public static interface OnItemClickListener {
        public void onItemClick(View var1, int var2);
    }
}

