/*
 * Decompiled with CFR 0.152.
 */
package sunmi.ds.gen;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import org.greenrobot.greendao.AbstractDaoMaster;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseOpenHelper;
import org.greenrobot.greendao.database.StandardDatabase;
import org.greenrobot.greendao.identityscope.IdentityScopeType;
import sunmi.ds.gen.DSFileDao;
import sunmi.ds.gen.DSFilesDao;
import sunmi.ds.gen.DaoSession;

public class DaoMaster
extends AbstractDaoMaster {
    public static final int SCHEMA_VERSION = 1;

    public static void createAllTables(Database db, boolean ifNotExists) {
        DSFileDao.createTable(db, ifNotExists);
        DSFilesDao.createTable(db, ifNotExists);
    }

    public static void dropAllTables(Database db, boolean ifExists) {
        DSFileDao.dropTable(db, ifExists);
        DSFilesDao.dropTable(db, ifExists);
    }

    public static DaoSession newDevSession(Context context, String name) {
        Database db = new DevOpenHelper(context, name).getWritableDb();
        DaoMaster daoMaster = new DaoMaster(db);
        return daoMaster.newSession();
    }

    public DaoMaster(SQLiteDatabase db) {
        this((Database)new StandardDatabase(db));
    }

    public DaoMaster(Database db) {
        super(db, 1);
        this.registerDaoClass(DSFileDao.class);
        this.registerDaoClass(DSFilesDao.class);
    }

    public DaoSession newSession() {
        return new DaoSession(this.db, IdentityScopeType.Session, this.daoConfigMap);
    }

    public DaoSession newSession(IdentityScopeType type) {
        return new DaoSession(this.db, type, this.daoConfigMap);
    }

    public static class DevOpenHelper
    extends OpenHelper {
        public DevOpenHelper(Context context, String name) {
            super(context, name);
        }

        public DevOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory) {
            super(context, name, factory);
        }

        public void onUpgrade(Database db, int oldVersion, int newVersion) {
            Log.i((String)"greenDAO", (String)("Upgrading schema from version " + oldVersion + " to " + newVersion + " by dropping all tables"));
            DaoMaster.dropAllTables(db, true);
            this.onCreate(db);
        }
    }

    public static abstract class OpenHelper
    extends DatabaseOpenHelper {
        public OpenHelper(Context context, String name) {
            super(context, name, 1);
        }

        public OpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory) {
            super(context, name, factory, 1);
        }

        public void onCreate(Database db) {
            Log.i((String)"greenDAO", (String)"Creating tables for schema version 1");
            DaoMaster.createAllTables(db, false);
        }
    }
}

