/*
 * Decompiled with CFR 0.152.
 */
package sunmi.ds.data;

import sunmi.ds.DSKernel;
import sunmi.ds.callback.ISendCallback;
import sunmi.ds.data.DSData;

public class DataPacket {
    private ISendCallback callback;
    private String recPackageName = DSKernel.getDSDPackageName();
    private DSData data;
    private boolean isReport = false;

    public ISendCallback getCallback() {
        return this.callback;
    }

    public String getRecPackageName() {
        return this.recPackageName;
    }

    public String getDataContent() {
        return this.data.data;
    }

    public DSData getData() {
        return this.data;
    }

    public void setData(DSData data) {
        this.data = data;
    }

    public boolean isReport() {
        return this.isReport;
    }

    public DSData.DataType getDataType() {
        return this.data.dataType;
    }

    public long getTaskId() {
        return this.data.taskId;
    }

    public long getFileId() {
        return this.data.fileId;
    }

    public long getQueryId() {
        return this.data.queryId;
    }

    private DataPacket(Builder b) {
        this.callback = b.callback;
        this.recPackageName = b.recPackageName;
        this.data = b.data;
        this.isReport = b.isReport;
    }

    public static class Builder {
        private ISendCallback callback;
        private String recPackageName;
        private DSData data = new DSData();
        private boolean isReport;

        public Builder(DSData.DataType dataType) {
            this.data.dataType = dataType;
        }

        public Builder recPackName(String recPackName) {
            this.recPackageName = recPackName;
            return this;
        }

        public Builder data(String data) {
            this.data.data = data;
            return this;
        }

        public Builder taskId(long taskId) {
            this.data.taskId = taskId;
            return this;
        }

        public Builder fileId(long fileId) {
            this.data.fileId = fileId;
            return this;
        }

        public Builder queryId(long queryId) {
            this.data.queryId = queryId;
            return this;
        }

        public Builder isReport(boolean isReport) {
            this.isReport = isReport;
            return this;
        }

        public Builder addCallback(ISendCallback callback) {
            this.callback = callback;
            return this;
        }

        public DataPacket build() {
            DataPacket packet = new DataPacket(this);
            return packet;
        }
    }
}

