package sunmi.ds.data;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;

import org.greenrobot.greendao.annotation.Convert;
import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Generated;
import org.greenrobot.greendao.annotation.Id;
import org.greenrobot.greendao.annotation.NotNull;
import org.greenrobot.greendao.converter.PropertyConverter;

import java.util.ArrayList;
import java.util.List;

/**
 * 多文件类
 */
@Entity
public class DSFiles {
    @Id
    public Long id;
    @NotNull
    public long taskId;
    @NotNull
    public String sender;
    @Convert(columnType = String.class, converter = FilesDescribeConverter.class)
    public FilesDescribe filesDescribe;
    @Convert(columnType = String.class, converter = ListConverter.class)
    public List<DSFile> files = new ArrayList<DSFile>();

    @Generated(hash = 1757275583)
    public DSFiles(Long id, long taskId, @NotNull String sender, FilesDescribe filesDescribe,
            List<DSFile> files) {
        this.id = id;
        this.taskId = taskId;
        this.sender = sender;
        this.filesDescribe = filesDescribe;
        this.files = files;
    }

    @Generated(hash = 1577888312)
    public DSFiles() {
    }

    public void addFile(DSFile file) {
        if (!files.contains(file)) {
            files.add(file);
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public FilesDescribe getFilesDescribe() {
        return this.filesDescribe;
    }

    public void setFilesDescribe(FilesDescribe filesDescribe) {
        this.filesDescribe = filesDescribe;
    }

    public List<DSFile> getFiles() {
        return this.files;
    }

    public void setFiles(List<DSFile> files) {
        this.files = files;
    }


    public static class ListConverter implements PropertyConverter<List<DSFile>, String> {

        @Override
        public List<DSFile> convertToEntityProperty(String databaseValue) {
            if (null == databaseValue) {
                return null;
            } else {
                return JSON.parseObject(databaseValue, new TypeReference<List<DSFile>>() {
                });
            }
        }

        @Override
        public String convertToDatabaseValue(List<DSFile> entityProperty) {
            if (null == entityProperty) {
                return null;
            } else {
                return JSON.toJSONString(entityProperty);
            }
        }
    }

    public static class FilesDescribeConverter implements PropertyConverter<FilesDescribe, String> {

        @Override
        public FilesDescribe convertToEntityProperty(String databaseValue) {
            if (null == databaseValue) {
                return null;
            } else {
                return JSON.parseObject(databaseValue, FilesDescribe.class);
            }

        }

        @Override
        public String convertToDatabaseValue(FilesDescribe entityProperty) {
            if (null == entityProperty) {
                return null;
            } else {
                return JSON.toJSONString(entityProperty);
            }
        }
    }
}


