package sunmi.ds.gen;

import java.util.Map;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.AbstractDaoSession;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.identityscope.IdentityScopeType;
import org.greenrobot.greendao.internal.DaoConfig;

import sunmi.ds.data.DSFile;
import sunmi.ds.data.DSFiles;

import sunmi.ds.gen.DSFileDao;
import sunmi.ds.gen.DSFilesDao;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.

/**
 * {@inheritDoc}
 * 
 * @see org.greenrobot.greendao.AbstractDaoSession
 */
public class DaoSession extends AbstractDaoSession {

    private final DaoConfig dSFileDaoConfig;
    private final DaoConfig dSFilesDaoConfig;

    private final DSFileDao dSFileDao;
    private final DSFilesDao dSFilesDao;

    public DaoSession(Database db, IdentityScopeType type, Map<Class<? extends AbstractDao<?, ?>>, DaoConfig>
            daoConfigMap) {
        super(db);

        dSFileDaoConfig = daoConfigMap.get(DSFileDao.class).clone();
        dSFileDaoConfig.initIdentityScope(type);

        dSFilesDaoConfig = daoConfigMap.get(DSFilesDao.class).clone();
        dSFilesDaoConfig.initIdentityScope(type);

        dSFileDao = new DSFileDao(dSFileDaoConfig, this);
        dSFilesDao = new DSFilesDao(dSFilesDaoConfig, this);

        registerDao(DSFile.class, dSFileDao);
        registerDao(DSFiles.class, dSFilesDao);
    }
    
    public void clear() {
        dSFileDaoConfig.clearIdentityScope();
        dSFilesDaoConfig.clearIdentityScope();
    }

    public DSFileDao getDSFileDao() {
        return dSFileDao;
    }

    public DSFilesDao getDSFilesDao() {
        return dSFilesDao;
    }

}
