/*
 * Decompiled with CFR 0.152.
 */
package sunmi.ds.gen;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import java.util.List;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.AbstractDaoSession;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;
import org.greenrobot.greendao.internal.DaoConfig;
import sunmi.ds.data.DSFile;
import sunmi.ds.data.DSFiles;
import sunmi.ds.data.FilesDescribe;
import sunmi.ds.gen.DaoSession;

public class DSFilesDao
extends AbstractDao<DSFiles, Long> {
    public static final String TABLENAME = "DSFILES";
    private final DSFiles.FilesDescribeConverter filesDescribeConverter = new DSFiles.FilesDescribeConverter();
    private final DSFiles.ListConverter filesConverter = new DSFiles.ListConverter();

    public DSFilesDao(DaoConfig config) {
        super(config);
    }

    public DSFilesDao(DaoConfig config, DaoSession daoSession) {
        super(config, (AbstractDaoSession)daoSession);
    }

    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists ? "IF NOT EXISTS " : "";
        db.execSQL("CREATE TABLE " + constraint + "\"DSFILES\" (\"_id\" INTEGER PRIMARY KEY ,\"TASK_ID\" INTEGER NOT NULL ,\"SENDER\" TEXT NOT NULL ,\"FILES_DESCRIBE\" TEXT,\"FILES\" TEXT);");
    }

    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"DSFILES\"";
        db.execSQL(sql);
    }

    protected final void bindValues(DatabaseStatement stmt, DSFiles entity) {
        List<DSFile> files;
        stmt.clearBindings();
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id.longValue());
        }
        stmt.bindLong(2, entity.getTaskId());
        stmt.bindString(3, entity.getSender());
        FilesDescribe filesDescribe = entity.getFilesDescribe();
        if (filesDescribe != null) {
            stmt.bindString(4, this.filesDescribeConverter.convertToDatabaseValue(filesDescribe));
        }
        if ((files = entity.getFiles()) != null) {
            stmt.bindString(5, this.filesConverter.convertToDatabaseValue(files));
        }
    }

    protected final void bindValues(SQLiteStatement stmt, DSFiles entity) {
        List<DSFile> files;
        stmt.clearBindings();
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id.longValue());
        }
        stmt.bindLong(2, entity.getTaskId());
        stmt.bindString(3, entity.getSender());
        FilesDescribe filesDescribe = entity.getFilesDescribe();
        if (filesDescribe != null) {
            stmt.bindString(4, this.filesDescribeConverter.convertToDatabaseValue(filesDescribe));
        }
        if ((files = entity.getFiles()) != null) {
            stmt.bindString(5, this.filesConverter.convertToDatabaseValue(files));
        }
    }

    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0));
    }

    public DSFiles readEntity(Cursor cursor, int offset) {
        DSFiles entity = new DSFiles(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)), cursor.getLong(offset + 1), cursor.getString(offset + 2), cursor.isNull(offset + 3) ? null : this.filesDescribeConverter.convertToEntityProperty(cursor.getString(offset + 3)), cursor.isNull(offset + 4) ? null : this.filesConverter.convertToEntityProperty(cursor.getString(offset + 4)));
        return entity;
    }

    public void readEntity(Cursor cursor, DSFiles entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)));
        entity.setTaskId(cursor.getLong(offset + 1));
        entity.setSender(cursor.getString(offset + 2));
        entity.setFilesDescribe(cursor.isNull(offset + 3) ? null : this.filesDescribeConverter.convertToEntityProperty(cursor.getString(offset + 3)));
        entity.setFiles(cursor.isNull(offset + 4) ? null : this.filesConverter.convertToEntityProperty(cursor.getString(offset + 4)));
    }

    protected final Long updateKeyAfterInsert(DSFiles entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }

    public Long getKey(DSFiles entity) {
        if (entity != null) {
            return entity.getId();
        }
        return null;
    }

    public boolean hasKey(DSFiles entity) {
        return entity.getId() != null;
    }

    protected final boolean isEntityUpdateable() {
        return true;
    }

    public static class Properties {
        public static final Property Id = new Property(0, Long.class, "id", true, "_id");
        public static final Property TaskId = new Property(1, Long.TYPE, "taskId", false, "TASK_ID");
        public static final Property Sender = new Property(2, String.class, "sender", false, "SENDER");
        public static final Property FilesDescribe = new Property(3, String.class, "filesDescribe", false, "FILES_DESCRIBE");
        public static final Property Files = new Property(4, String.class, "files", false, "FILES");
    }
}

