/*
 * Decompiled with CFR 0.152.
 */
package sunmi.ds;

import java.util.List;
import sunmi.ds.DSKernel;
import sunmi.ds.callback.ISendCallback;
import sunmi.ds.callback.ISendFilesCallback;

class SendFilesHandler
implements ISendCallback {
    private List<String> files;
    private int count;
    private ISendFilesCallback userCallback;
    private DSKernel dsKernel;
    private String recePackageName;

    public SendFilesHandler(DSKernel dsKernel, List<String> files, String recePackageName, ISendFilesCallback callback) {
        this.dsKernel = dsKernel;
        this.files = files;
        this.userCallback = callback;
        this.recePackageName = recePackageName;
    }

    @Override
    public void onSendSuccess(long taskId) {
        for (final String path : this.files) {
            this.dsKernel.sendFile(taskId, this.recePackageName, path, new ISendCallback(){

                @Override
                public void onSendSuccess(long taskId) {
                    SendFilesHandler.this.userCallback.onSendSuccess(path, taskId);
                    SendFilesHandler.this.count(taskId);
                }

                @Override
                public void onSendFail(int errorId, String errorInfo) {
                    SendFilesHandler.this.userCallback.onSendFileFaile(path, errorId, errorInfo);
                }

                @Override
                public void onSendProcess(long totle, long sended) {
                    SendFilesHandler.this.userCallback.onSendProcess(path, totle, sended);
                }
            });
        }
    }

    @Override
    public void onSendFail(int errorId, String errorInfo) {
        this.userCallback.onSendFaile(-400, "msg \u53d1\u9001\u5931\u8d25\u9519\u8bef");
    }

    @Override
    public void onSendProcess(long totle, long sended) {
    }

    private synchronized void count(long fileId) {
        ++this.count;
        if (this.files.size() == this.count) {
            this.userCallback.onAllSendSuccess(fileId);
            this.count = 0;
        }
    }
}

