package sunmi.ds.gen;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import sunmi.ds.data.DSFile;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "DSFILE".
*/
public class DSFileDao extends AbstractDao<DSFile, Long> {

    public static final String TABLENAME = "DSFILE";

    /**
     * Properties of entity DSFile.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property Sender = new Property(1, String.class, "sender", false, "SENDER");
        public final static Property Path = new Property(2, String.class, "path", false, "PATH");
        public final static Property TaskId = new Property(3, long.class, "taskId", false, "TASK_ID");
    }


    public DSFileDao(DaoConfig config) {
        super(config);
    }
    
    public DSFileDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"DSFILE\" (" + //
                "\"_id\" INTEGER PRIMARY KEY ," + // 0: id
                "\"SENDER\" TEXT NOT NULL ," + // 1: sender
                "\"PATH\" TEXT NOT NULL ," + // 2: path
                "\"TASK_ID\" INTEGER NOT NULL );"); // 3: taskId
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"DSFILE\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, DSFile entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindString(2, entity.getSender());
        stmt.bindString(3, entity.getPath());
        stmt.bindLong(4, entity.getTaskId());
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, DSFile entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindString(2, entity.getSender());
        stmt.bindString(3, entity.getPath());
        stmt.bindLong(4, entity.getTaskId());
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public DSFile readEntity(Cursor cursor, int offset) {
        DSFile entity = new DSFile( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.getString(offset + 1), // sender
            cursor.getString(offset + 2), // path
            cursor.getLong(offset + 3) // taskId
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, DSFile entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setSender(cursor.getString(offset + 1));
        entity.setPath(cursor.getString(offset + 2));
        entity.setTaskId(cursor.getLong(offset + 3));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(DSFile entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(DSFile entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(DSFile entity) {
        return entity.getId() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
