package sunmi.ds.gen;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import java.util.List;
import sunmi.ds.data.DSFiles.FilesDescribeConverter;
import sunmi.ds.data.DSFiles.ListConverter;
import sunmi.ds.data.FilesDescribe;

import sunmi.ds.data.DSFiles;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "DSFILES".
*/
public class DSFilesDao extends AbstractDao<DSFiles, Long> {

    public static final String TABLENAME = "DSFILES";

    /**
     * Properties of entity DSFiles.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property TaskId = new Property(1, long.class, "taskId", false, "TASK_ID");
        public final static Property Sender = new Property(2, String.class, "sender", false, "SENDER");
        public final static Property FilesDescribe = new Property(3, String.class, "filesDescribe", false, "FILES_DESCRIBE");
        public final static Property Files = new Property(4, String.class, "files", false, "FILES");
    }

    private final FilesDescribeConverter filesDescribeConverter = new FilesDescribeConverter();
    private final ListConverter filesConverter = new ListConverter();

    public DSFilesDao(DaoConfig config) {
        super(config);
    }
    
    public DSFilesDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"DSFILES\" (" + //
                "\"_id\" INTEGER PRIMARY KEY ," + // 0: id
                "\"TASK_ID\" INTEGER NOT NULL ," + // 1: taskId
                "\"SENDER\" TEXT NOT NULL ," + // 2: sender
                "\"FILES_DESCRIBE\" TEXT," + // 3: filesDescribe
                "\"FILES\" TEXT);"); // 4: files
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"DSFILES\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, DSFiles entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getTaskId());
        stmt.bindString(3, entity.getSender());
 
        FilesDescribe filesDescribe = entity.getFilesDescribe();
        if (filesDescribe != null) {
            stmt.bindString(4, filesDescribeConverter.convertToDatabaseValue(filesDescribe));
        }
 
        List files = entity.getFiles();
        if (files != null) {
            stmt.bindString(5, filesConverter.convertToDatabaseValue(files));
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, DSFiles entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getTaskId());
        stmt.bindString(3, entity.getSender());
 
        FilesDescribe filesDescribe = entity.getFilesDescribe();
        if (filesDescribe != null) {
            stmt.bindString(4, filesDescribeConverter.convertToDatabaseValue(filesDescribe));
        }
 
        List files = entity.getFiles();
        if (files != null) {
            stmt.bindString(5, filesConverter.convertToDatabaseValue(files));
        }
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public DSFiles readEntity(Cursor cursor, int offset) {
        DSFiles entity = new DSFiles( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.getLong(offset + 1), // taskId
            cursor.getString(offset + 2), // sender
            cursor.isNull(offset + 3) ? null : filesDescribeConverter.convertToEntityProperty(cursor.getString(offset + 3)), // filesDescribe
            cursor.isNull(offset + 4) ? null : filesConverter.convertToEntityProperty(cursor.getString(offset + 4)) // files
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, DSFiles entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setTaskId(cursor.getLong(offset + 1));
        entity.setSender(cursor.getString(offset + 2));
        entity.setFilesDescribe(cursor.isNull(offset + 3) ? null : filesDescribeConverter.convertToEntityProperty(cursor.getString(offset + 3)));
        entity.setFiles(cursor.isNull(offset + 4) ? null : filesConverter.convertToEntityProperty(cursor.getString(offset + 4)));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(DSFiles entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(DSFiles entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(DSFiles entity) {
        return entity.getId() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
