/*
 * Decompiled with CFR 0.152.
 */
package sunmi.ds;

import org.json.JSONException;
import org.json.JSONObject;
import sunmi.ds.SF;
import sunmi.ds.callback.ISendCallback;
import sunmi.ds.data.DSData;
import sunmi.ds.data.DataPacket;

class PacketFactory {
    PacketFactory() {
    }

    public static DataPacket buildResultPack(String recePackageName, String result, long queryId, ISendCallback callback) {
        return new DataPacket.Builder(DSData.DataType.DATA).data(result).queryId(queryId).recPackName(recePackageName).addCallback(callback).isReport(true).build();
    }

    public static DataPacket buildQueryPack(String recePackageName, String queryJson, ISendCallback callback) {
        return new DataPacket.Builder(DSData.DataType.DATA).data(queryJson).recPackName(recePackageName).addCallback(callback).isReport(true).build();
    }

    public static DataPacket buildCMDPack(String recePackageName, String dataJson, long fileId, ISendCallback callback) {
        return new DataPacket.Builder(DSData.DataType.CMD).data(dataJson).fileId(fileId).recPackName(recePackageName).addCallback(callback).isReport(true).build();
    }

    public static DataPacket buildPack(String recePackageName, DSData.DataType dataType, String dataJson, ISendCallback callback) {
        return new DataPacket.Builder(dataType).data(dataJson).recPackName(recePackageName).addCallback(callback).isReport(true).build();
    }

    public static DataPacket buildPreFilePacket(String recePackageName, String json, ISendCallback callback) {
        return new DataPacket.Builder(DSData.DataType.PRE_FILES).data(json).recPackName(recePackageName).addCallback(callback).isReport(true).build();
    }

    public static DataPacket buildFilePacket(String recePackageName, String filePath, ISendCallback callback) {
        return new DataPacket.Builder(DSData.DataType.FILE).data(filePath).recPackName(recePackageName).addCallback(callback).isReport(true).build();
    }

    public static DataPacket buildFilePacket(long taskId, String recePackageName, String filePath, ISendCallback callback) {
        return new DataPacket.Builder(DSData.DataType.FILE).data(filePath).taskId(taskId).recPackName(recePackageName).addCallback(callback).isReport(true).build();
    }

    public static DataPacket buildCheckConnection(String sender, ISendCallback callback) {
        DataPacket dsPacket = new DataPacket.Builder(DSData.DataType.CHECK_CONN).data(sender).recPackName(SF.DSD_PACKNAME).addCallback(callback).isReport(true).build();
        return dsPacket;
    }

    public static DataPacket buildConnectionOK(String recePackName) {
        String json = PacketFactory.createJson("DEF_KEY", "def-value");
        return new DataPacket.Builder(DSData.DataType.OK_CONN).data(json).recPackName(recePackName).isReport(true).build();
    }

    static String createJson(String key, Object value) {
        JSONObject json = new JSONObject();
        try {
            json.put(key, value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json.toString();
    }

    static String createJson(String key, int value) {
        JSONObject json = new JSONObject();
        try {
            json.put(key, value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json.toString();
    }
}

