/*
 * Decompiled with CFR 0.152.
 */
package sunmi.ds;

import android.content.Context;
import android.util.Log;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sunmi.ds.SharedPreferencesUtil;
import sunmi.ds.data.DSFile;
import sunmi.ds.data.DSFiles;

public class FilesManager {
    private static final String DS_FILE_LIST = "DSFileList";
    private static final String DS_FILES_LIST = "DSFilesList";
    Context context;
    private static FilesManager instance;
    Map<Long, DSFile> receFileList = new HashMap<Long, DSFile>();
    Map<Long, DSFiles> receFilesList = new HashMap<Long, DSFiles>();

    private FilesManager() {
    }

    public static FilesManager getInstance() {
        if (instance == null) {
            instance = new FilesManager();
        }
        return instance;
    }

    public void init(Context context) {
        this.context = context;
        Map dsFileMap = (Map)SharedPreferencesUtil.readDsFile(context, DS_FILE_LIST, this.receFilesList.getClass());
        Map dsFilesMap = (Map)SharedPreferencesUtil.readDsFiles(context, DS_FILES_LIST, this.receFilesList.getClass());
        if (null != dsFileMap) {
            this.receFileList = (Map)SharedPreferencesUtil.readDsFile(context, DS_FILE_LIST, this.receFilesList.getClass());
        }
        if (null != dsFilesMap) {
            this.receFilesList = (Map)SharedPreferencesUtil.readDsFiles(context, DS_FILES_LIST, this.receFilesList.getClass());
        }
    }

    public synchronized void saveFile(DSFile dsFile) {
        this.receFileList.put(dsFile.taskId, dsFile);
        SharedPreferencesUtil.saveObj(this.context, this.receFileList, DS_FILE_LIST);
    }

    public synchronized DSFile getFile(Long taskId) {
        return this.receFileList.get(taskId);
    }

    public synchronized void saveFiles(DSFiles dsFiles) {
        this.receFilesList.put(dsFiles.taskId, dsFiles);
        SharedPreferencesUtil.saveObj(this.context, this.receFilesList, DS_FILES_LIST);
    }

    public synchronized DSFiles getFiles(Long taskId) {
        return this.receFilesList.get(taskId);
    }

    public boolean checkFileExist(long fileId) {
        FilesManager filesManager = FilesManager.getInstance();
        DSFile file = filesManager.getFile(fileId);
        DSFiles files = filesManager.getFiles(fileId);
        if (file != null) {
            File file1 = new File(file.path);
            if (file1.exists()) {
                Log.d((String)"highsixty", (String)(file.path + "\u6587\u4ef6\u5b58\u5728"));
                return true;
            }
            Log.d((String)"highsixty", (String)(file.path + "\u6587\u4ef6\u4e0d\u5b58\u5728"));
            return false;
        }
        if (files != null) {
            List<DSFile> filePaths = files.files;
            for (int i = 0; i < filePaths.size(); ++i) {
                File file1 = new File(filePaths.get((int)i).path);
                if (!file1.exists()) {
                    Log.d((String)"highsixty", (String)("\u591a\u6587\u4ef6\u4e2d" + filePaths.get((int)i).path + "\u6587\u4ef6\u4e0d\u5b58\u5728"));
                    return false;
                }
                Log.d((String)"highsixty", (String)("\u591a\u6587\u4ef6\u4e2d" + filePaths.get((int)i).path + "\u6587\u4ef6\u5b58\u5728"));
            }
            return true;
        }
        Log.d((String)"highsixty", (String)(fileId + "\u6587\u4ef6\u5728\u5e94\u7528\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728"));
        return false;
    }

    public boolean deleteFile(long fileId) {
        FilesManager filesManager = FilesManager.getInstance();
        DSFile file = filesManager.getFile(fileId);
        DSFiles files = filesManager.getFiles(fileId);
        if (file != null) {
            File file1 = new File(file.path);
            if (!file1.exists()) {
                Log.d((String)"highsixty", (String)(fileId + "\u6587\u4ef6\u5728\u5e94\u7528\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728,\u4e0d\u9700\u8981\u505a\u5220\u9664\u64cd\u4f5c"));
                return true;
            }
            Log.d((String)"highsixty", (String)(fileId + "\u6587\u4ef6\u5728\u5e94\u7528\u7f13\u5b58\u4e2d\u5b58\u5728,\u505a\u5220\u9664\u64cd\u4f5c" + file1.getAbsolutePath()));
            return file1.delete();
        }
        if (files != null) {
            List<DSFile> filePaths = files.files;
            for (int i = 0; i < filePaths.size(); ++i) {
                File file1 = new File(filePaths.get((int)i).path);
                if (file1.exists()) {
                    Log.d((String)"highsixty", (String)(fileId + "\u6587\u4ef6\u5728\u5e94\u7528\u7f13\u5b58\u4e2d\u5b58\u5728,\u505a\u5220\u9664\u64cd\u4f5c" + file1.getAbsolutePath()));
                    if (file1.delete()) continue;
                    return false;
                }
                Log.d((String)"highsixty", (String)(fileId + "\u591a\u6587\u4ef6\u5728\u5e94\u7528\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728,\u4e0d\u9700\u8981\u505a\u5220\u9664\u64cd\u4f5c" + file1.getAbsolutePath()));
            }
            return true;
        }
        Log.d((String)"highsixty", (String)(fileId + "\u6587\u4ef6\u5728\u5e94\u7528\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728,\u4e0d\u9700\u8981\u505a\u5220\u9664\u64cd\u4f5c"));
        return true;
    }
}

