/*
 * Decompiled with CFR 0.152.
 */
package sunmi.ds;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.sunmi.aidl.SendService;
import com.sunmi.aidl.SendServiceCallback;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import sunmi.ds.DSReceiver;
import sunmi.ds.PacketFactory;
import sunmi.ds.Root;
import sunmi.ds.SF;
import sunmi.ds.SendFilesHandler;
import sunmi.ds.callback.ICheckFileCallback;
import sunmi.ds.callback.IConnectionCallback;
import sunmi.ds.callback.IReceiveCallback;
import sunmi.ds.callback.ISendCallback;
import sunmi.ds.callback.ISendFilesCallback;
import sunmi.ds.callback.QueryCallback;
import sunmi.ds.data.DSData;
import sunmi.ds.data.DataPacket;
import sunmi.ds.data.FilesDescribe;
import sunmi.ds.exception.ParameterException;
import sunmi.ds.utils.ProcessUtils;

public class DSKernel {
    private static final String TAG = "DSKernel";
    private boolean binding = false;
    private SendService mService;
    private static DSKernel mInstance = new DSKernel();
    private Context mCtx;
    private boolean isConnected = false;
    private List<IConnectionCallback> mConnCallbackList = new ArrayList<IConnectionCallback>();
    private Root root = new Root();
    private DSReceiver mDSReceiver;
    private Handler handler = new Handler();
    private ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceDisconnected(ComponentName name) {
            DSKernel.this.mService = null;
            DSKernel.this.binding = false;
            DSKernel.this.onConnStateChange(IConnectionCallback.ConnState.DIS_CONN);
            DSKernel.this.mService = null;
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            DSKernel.this.mService = SendService.Stub.asInterface(service);
            DSKernel.this.binding = false;
            DSKernel.this.onConnStateChange(IConnectionCallback.ConnState.AIDL_CONN);
            DSKernel.this.checkConnection();
        }
    };

    private DSKernel() {
    }

    public static DSKernel newInstance() {
        if (mInstance == null) {
            mInstance = new DSKernel();
        }
        return mInstance;
    }

    public static String getDSDPackageName() {
        return SF.DSD_PACKNAME;
    }

    public void init(Context contetx, IConnectionCallback stateCallback, String vicePackageName) {
        if (!TextUtils.isEmpty((CharSequence)vicePackageName)) {
            SF.DSD_PACKNAME = vicePackageName;
        }
        this.init(contetx, stateCallback);
    }

    public void init(Context contetx, IConnectionCallback stateCallback) {
        if (stateCallback == null) {
            throw new ParameterException();
        }
        this.mCtx = contetx.getApplicationContext();
        this.initDSReceiver();
        this.addConnCallback(stateCallback);
        this.doBind();
    }

    void initDSReceiver() {
        this.mDSReceiver = DSReceiver.getInstance(this.mCtx);
        this.mDSReceiver.setDSKernel(this);
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void addReceiveCallback(IReceiveCallback receiveCallback) {
        this.mDSReceiver.addReceiveCallback(receiveCallback);
    }

    public void removeReceiveCallback(IReceiveCallback receiveCallback) {
        this.mDSReceiver.removeReceiveCallback(receiveCallback);
    }

    public void addConnCallback(IConnectionCallback callback) {
        if (!this.mConnCallbackList.contains(callback)) {
            this.mConnCallbackList.add(callback);
        }
    }

    public void removeConnCallback(IConnectionCallback callback) {
        this.mConnCallbackList.remove(callback);
    }

    public void onDestroy() {
        this.mCtx.unbindService(this.mConnection);
        this.mConnection = null;
        this.mDSReceiver = null;
        this.mConnCallbackList.clear();
        mInstance = null;
    }

    public void sendCMD(String recePackageName, String dataJson, long fileId, ISendCallback callback) {
        DataPacket dataPacket = PacketFactory.buildCMDPack(recePackageName, dataJson, fileId, callback);
        this.sendData(dataPacket);
    }

    public void sendCMD(DataPacket dataPacket) {
        this.sendData(dataPacket);
    }

    public void sendData(DataPacket dataPacket) {
        if (!this.checkParametes(dataPacket)) {
            return;
        }
        this.dispatchData(dataPacket);
    }

    public void sendQuery(String recePackageName, String queryStr, ISendCallback sendCallback, QueryCallback callback) {
        DataPacket pack = PacketFactory.buildQueryPack(recePackageName, queryStr, sendCallback);
        if (callback == null) {
            throw new ParameterException();
        }
        if (!this.checkParametes(pack)) {
            return;
        }
        this.mDSReceiver.addQueryCallback(pack.getTaskId(), callback);
        this.sendData(pack);
    }

    public void sendQuery(DataPacket pack, QueryCallback callback) {
        if (callback == null) {
            throw new ParameterException();
        }
        if (!this.checkParametes(pack)) {
            return;
        }
        this.mDSReceiver.addQueryCallback(pack.getTaskId(), callback);
        this.sendData(pack);
    }

    public void sendResult(String recePackageName, String resultStr, long queryId, ISendCallback sendCallback) {
        DataPacket pack = PacketFactory.buildResultPack(recePackageName, resultStr, queryId, sendCallback);
        this.sendData(pack);
    }

    private boolean checkParametes(DataPacket mPack) {
        boolean isforegroundApp;
        boolean isOK = true;
        if (this.mCtx == null) {
            throw new RuntimeException("SDK not initialized, call init() method to initialize.");
        }
        if (!this.root.isRoot(this.mCtx.getPackageName()) && !(isforegroundApp = ProcessUtils.isForegroundAppFor21(this.mCtx, this.mCtx.getPackageName()))) {
            Log.d((String)TAG, (String)"\u5f53\u524dapp\u4e0d\u518d\u524d\u53f0\u4e0d\u5141\u8bb8\u5411\u526f\u5c4f\u53d1\u9001\u6570\u636e");
            isOK = false;
        }
        if (!this.verifyParameter(mPack)) {
            throw new ParameterException();
        }
        return isOK;
    }

    public long sendFile(String recePackName, String filePath, ISendCallback callback) {
        DataPacket dsPack = PacketFactory.buildFilePacket(recePackName, filePath, callback);
        this.sendData(dsPack);
        return dsPack.getData().taskId;
    }

    public long sendFile(long taskId, String recePackName, String filePath, ISendCallback callback) {
        DataPacket dsPack = PacketFactory.buildFilePacket(taskId, recePackName, filePath, callback);
        this.sendData(dsPack);
        return dsPack.getData().taskId;
    }

    public long sendFile(final String recePackName, String msg, final String filePath, final ISendCallback callback) {
        FilesDescribe fd = new FilesDescribe();
        fd.msg = msg;
        fd.fileCount = 1;
        String json = JSON.toJSONString((Object)fd);
        DataPacket dsPack = PacketFactory.buildPreFilePacket(recePackName, json, new ISendCallback(){

            @Override
            public void onSendSuccess(long taskId) {
                DSKernel.this.sendFile(taskId, recePackName, filePath, callback);
            }

            @Override
            public void onSendFail(int errorId, String errorInfo) {
                callback.onSendFail(-400, "msg \u53d1\u9001\u5931\u8d25\u9519\u8bef");
            }

            @Override
            public void onSendProcess(long totle, long sended) {
            }
        });
        this.sendData(dsPack);
        return dsPack.getTaskId();
    }

    public long sendFiles(String recePackName, String msg, List<String> files, ISendFilesCallback callback) {
        FilesDescribe fd = new FilesDescribe();
        fd.msg = msg;
        fd.fileCount = files.size();
        String json = JSON.toJSONString((Object)fd);
        SendFilesHandler handler = new SendFilesHandler(this, files, recePackName, callback);
        DataPacket dsPack = PacketFactory.buildPreFilePacket(recePackName, json, handler);
        this.sendData(dsPack);
        return dsPack.getTaskId();
    }

    public void checkFileExist(long fileId, final ICheckFileCallback callback) {
        DataPacket pack = PacketFactory.buildPack(SF.DSD_PACKNAME, DSData.DataType.CHECK_FILE, "def", new ISendCallback(){

            @Override
            public void onSendSuccess(long taskId) {
            }

            @Override
            public void onSendFail(int errorId, String errorInfo) {
                callback.onCheckFail();
            }

            @Override
            public void onSendProcess(long totle, long sended) {
            }
        });
        pack.getData().fileId = fileId;
        this.sendQuery(pack, new QueryCallback(){

            @Override
            public void onReceiveData(DSData data) {
                boolean exist = TextUtils.equals((CharSequence)"true", (CharSequence)data.data);
                callback.onResult(exist);
            }
        });
    }

    public void deleteFileExist(long fileId, final ICheckFileCallback callback) {
        DataPacket pack = PacketFactory.buildPack(SF.DSD_PACKNAME, DSData.DataType.CHECK_FILE, "delete", new ISendCallback(){

            @Override
            public void onSendSuccess(long taskId) {
            }

            @Override
            public void onSendFail(int errorId, String errorInfo) {
                callback.onCheckFail();
            }

            @Override
            public void onSendProcess(long totle, long sended) {
            }
        });
        pack.getData().fileId = fileId;
        this.sendQuery(pack, new QueryCallback(){

            @Override
            public void onReceiveData(DSData data) {
                boolean exist = TextUtils.equals((CharSequence)"true", (CharSequence)data.data);
                callback.onResult(exist);
            }
        });
    }

    void sendConnOK(String sender) {
        DataPacket dsPacket = PacketFactory.buildConnectionOK(sender);
        this.sendData(dsPacket);
    }

    public void checkConnection() {
        if (this.mService == null) {
            this.doBind();
            return;
        }
        DataPacket dsPack = PacketFactory.buildCheckConnection(this.mCtx.getPackageName(), new ISendCallback(){

            @Override
            public void onSendSuccess(long taskId) {
                DSKernel.this.onConnStateChange(IConnectionCallback.ConnState.VICE_SERVICE_CONN);
            }

            @Override
            public void onSendFail(int errorId, String errorInfo) {
                Log.e((String)DSKernel.TAG, (String)("checkConnection() onSendFail: errId:" + errorId + " errorInfo:" + errorInfo));
            }

            @Override
            public void onSendProcess(long totle, long sended) {
            }
        });
        this.sendData(dsPack);
    }

    private void dispatchData(final DataPacket mPack) {
        ISendCallback callback = mPack.getCallback();
        DSData data = mPack.getData();
        if (this.mService != null) {
            switch (data.getDataType()) {
                case FILE: {
                    this.sendFile(mPack);
                    break;
                }
                case CHECK_FILE: 
                case CHECK_CONN: 
                case OK_CONN: 
                case CMD: 
                case DATA: 
                case PRE_FILES: {
                    this.sendMemoryData(mPack);
                    break;
                }
            }
        } else if (this.binding) {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    DSKernel.this.dispatchData(mPack);
                }
            }, 10L);
        } else if (callback != null) {
            callback.onSendFail(-514, "\u672c\u5730\u901a\u4fe1\u670d\u52a1\u672a\u8fde\u63a5\u6210\u529f,\u8bf7\u68c0\u67e5\u672c\u5730\u662f\u5426\u5b58\u5728\u53cc\u5c4f\u901a\u4fe1\u670d\u52a1,\u6216\u8005\u7a0d\u540e\u518d\u8bd5");
        }
    }

    public void TEST(String data) {
        try {
            this.mService.sendByteToMemory(SF.SUNMI_DSD_PACKNAME, data.getBytes("utf-8"), null);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private void sendMemoryData(DataPacket mPack) {
        final ISendCallback callback = mPack.getCallback();
        final DSData data = mPack.getData();
        try {
            String dataJson = JSON.toJSONString((Object)data);
            try {
                this.mService.sendByteToMemory(mPack.getRecPackageName(), dataJson.getBytes("utf-8"), new SendServiceCallback.Stub(){

                    @Override
                    public void sendSuccess(int id) throws RemoteException {
                        Log.d((String)DSKernel.TAG, (String)"\u6587\u5b57\u4fe1\u606f\u53d1\u9001\u6210\u529f");
                        if (callback != null) {
                            callback.onSendSuccess(data.taskId);
                        }
                    }

                    @Override
                    public void sendProcess(int id, long totle, long sended) throws RemoteException {
                    }

                    @Override
                    public void sendError(int id, int errorId, String errorInfo) throws RemoteException {
                        Log.e((String)DSKernel.TAG, (String)("\u6587\u5b57\u4fe1\u606f\u53d1\u9001\u5931\u8d25:errorId:" + errorId + " errorInfo:" + errorInfo));
                        if (callback != null) {
                            callback.onSendFail(errorId, errorInfo);
                        }
                    }
                });
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
            if (callback != null) {
                callback.onSendFail(-513, "AIDL\u5f02\u5e38");
            }
            this.onConnStateChange(IConnectionCallback.ConnState.DIS_CONN);
        }
    }

    private void sendFile(DataPacket mPack) {
        final ISendCallback callback = mPack.getCallback();
        final DSData data = mPack.getData();
        try {
            this.mService.sendFileToFile(mPack.getRecPackageName(), data.data, mPack.isReport(), data.taskId, new SendServiceCallback.Stub(){

                @Override
                public void sendSuccess(int id) throws RemoteException {
                    if (callback != null) {
                        callback.onSendSuccess(data.taskId);
                    }
                }

                @Override
                public void sendProcess(int id, long totle, long sended) throws RemoteException {
                    if (callback != null) {
                        callback.onSendProcess(totle, sended);
                    }
                }

                @Override
                public void sendError(int id, int errorId, String errorInfo) throws RemoteException {
                    Log.e((String)DSKernel.TAG, (String)("\u6587\u4ef6\u53d1\u9001\u5931\u8d25:errorId:" + errorId + " errorInfo:" + errorInfo));
                    if (callback != null) {
                        callback.onSendFail(errorId, errorInfo);
                    }
                }
            });
        }
        catch (RemoteException e) {
            e.printStackTrace();
            if (callback != null) {
                callback.onSendFail(-513, "AIDL\u5f02\u5e38");
            }
            this.onConnStateChange(IConnectionCallback.ConnState.DIS_CONN);
        }
    }

    private void doBind() {
        try {
            Intent i = new Intent();
            i.setAction("com.sunmi.mainservice.CoreService");
            i.setPackage("com.sunmi.hcservice");
            this.mCtx.startService(i);
            this.binding = true;
            this.mCtx.bindService(i, this.mConnection, 1);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            this.mService = null;
        }
    }

    private boolean verifyParameter(DataPacket dsPack) {
        boolean flag = true;
        if (dsPack == null) {
            flag = false;
        }
        if (this.mConnCallbackList.isEmpty()) {
            Log.e((String)TAG, (String)"connCallbackList.isEmpty()!");
            flag = false;
        }
        ISendCallback callback = dsPack.getCallback();
        if (TextUtils.isEmpty((CharSequence)dsPack.getRecPackageName())) {
            if (callback != null) {
                callback.onSendFail(-512, "RecPackName isEmpty");
            }
            flag = false;
        }
        if (TextUtils.isEmpty((CharSequence)dsPack.getDataContent())) {
            if (callback != null) {
                callback.onSendFail(-512, "DataPacket isEmpty");
            }
            flag = false;
        }
        if (dsPack.getDataType() == null) {
            if (callback != null) {
                callback.onSendFail(-512, "dataType == null");
            }
            flag = false;
        }
        return flag;
    }

    public void onConnStateChange(IConnectionCallback.ConnState state) {
        if (this.mConnCallbackList.isEmpty()) {
            return;
        }
        switch (state) {
            case DIS_CONN: {
                this.isConnected = false;
                for (IConnectionCallback callback : this.mConnCallbackList) {
                    callback.onDisConnect();
                }
                break;
            }
            case AIDL_CONN: {
                this.isConnected = false;
                for (IConnectionCallback callback : this.mConnCallbackList) {
                    callback.onConnected(state);
                }
                break;
            }
            case VICE_SERVICE_CONN: {
                this.isConnected = true;
                for (IConnectionCallback callback : this.mConnCallbackList) {
                    callback.onConnected(state);
                }
                break;
            }
            case VICE_APP_CONN: {
                this.isConnected = true;
                for (IConnectionCallback callback : this.mConnCallbackList) {
                    callback.onConnected(state);
                }
                break;
            }
        }
    }
}

