package sunmi.ds;

import android.content.Context;
import android.util.Log;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import sunmi.ds.data.DSFile;
import sunmi.ds.data.DSFiles;

/**
 * 缓存接收到的文件
 * Created by longtao.li on 2016/9/8.
 */
public class FilesManager {

    private static final String DS_FILE_LIST = "DSFileList";
    private static final String DS_FILES_LIST = "DSFilesList";

    private FilesManager() {
    }

    Context context;

    private static FilesManager instance;

    public static FilesManager getInstance() {
        if (instance == null) {
            instance = new FilesManager();
        }
        return instance;
    }

    /**
     * 初始化filesmanager 是耗时操作
     *
     * @param context
     */
    public void init(Context context) {
        this.context = context;
        Map<Long, DSFile> dsFileMap = SharedPreferencesUtil.readDsFile(context, DS_FILE_LIST, receFilesList.getClass());
        Map<Long, DSFiles> dsFilesMap = SharedPreferencesUtil.readDsFiles(context, DS_FILES_LIST, receFilesList.getClass());
        if (null !=dsFileMap ) {
            receFileList = SharedPreferencesUtil.readDsFile(context, DS_FILE_LIST, receFilesList.getClass());
        }
        if (null !=dsFilesMap) {
            receFilesList = SharedPreferencesUtil.readDsFiles(context, DS_FILES_LIST, receFilesList.getClass());
        }
    }

    Map<Long, DSFile> receFileList = new HashMap<Long, DSFile>(); // 需要持久化

    Map<Long, DSFiles> receFilesList = new HashMap<Long, DSFiles>(); // 需要持久化

    public synchronized void saveFile(DSFile dsFile) {
        receFileList.put(dsFile.taskId, dsFile);
        SharedPreferencesUtil.saveObj(context, receFileList, DS_FILE_LIST);
    }

    /**
     * 根据任务Id,获取单个缓存文件
     *
     * @param taskId
     * @return
     */
    public synchronized DSFile getFile(Long taskId) {
        return receFileList.get(taskId);
    }


    public synchronized void saveFiles(DSFiles dsFiles) {
        receFilesList.put(dsFiles.taskId, dsFiles);
        SharedPreferencesUtil.saveObj(context, receFilesList, DS_FILES_LIST);
    }

    /**
     * 根据任务Id，获取同一任务的多个缓存文件
     *
     * @param taskId
     * @return
     */
    public synchronized DSFiles getFiles(Long taskId) {
        return receFilesList.get(taskId);
    }


    public boolean checkFileExist(long fileId) {
        FilesManager filesManager = FilesManager.getInstance();
        DSFile file = filesManager.getFile(fileId);
        DSFiles files = filesManager.getFiles(fileId);
        if (file != null) { //单文件不为null的时候判断单个文件
            File file1 = new File(file.path);
            if (file1.exists()) {
                Log.d("highsixty", file.path + "文件存在");
                return true;
            } else {
                Log.d("highsixty", file.path + "文件不存在");
                return false;
            }
        } else if (files != null) { //多文件判断
            List<DSFile> filePaths = files.files;
            for (int i = 0; i < filePaths.size(); i++) {
                File file1 = new File(filePaths.get(i).path);
                if (file1.exists()) {
                    Log.d("highsixty", "多文件中" + filePaths.get(i).path + "文件存在");
                    continue;
                } else {
                    Log.d("highsixty", "多文件中" + filePaths.get(i).path + "文件不存在");
                    return false;
                }
            }
            return true;
        } else {
            Log.d("highsixty", fileId + "文件在应用缓存中不存在");
            return false;
        }
    }

    /**
     * 删除指定文件id的缓存文件
     *
     * @param fileId
     * @return
     */
    public boolean deleteFile(long fileId) {
        FilesManager filesManager = FilesManager.getInstance();
        DSFile file = filesManager.getFile(fileId);
        DSFiles files = filesManager.getFiles(fileId);
        if (file != null) { //单文件不为null的时候判断单个文件
            File file1 = new File(file.path);
            if(!file1.exists()) {
                Log.d("highsixty", fileId + "文件在应用缓存中不存在,不需要做删除操作");
                return true ;
            }else{
                Log.d("highsixty", fileId + "文件在应用缓存中存在,做删除操作"+file1.getAbsolutePath());
                return file1.delete();
            }
        } else if (files != null) { //多文件判断
            List<DSFile> filePaths = files.files;
            for (int i = 0; i < filePaths.size(); i++) {
                File file1 = new File(filePaths.get(i).path);
                if (file1.exists()) {
                    Log.d("highsixty", fileId + "文件在应用缓存中存在,做删除操作"+file1.getAbsolutePath());
                    if(file1.delete()) {
                        continue;
                    }else{
                        return  false ;
                    }
                } else {
                    Log.d("highsixty", fileId + "多文件在应用缓存中不存在,不需要做删除操作"+file1.getAbsolutePath());
                    continue;
                }
            }
            return true;
        } else {
            Log.d("highsixty", fileId + "文件在应用缓存中不存在,不需要做删除操作");
            return true;
        }

    }
}
