/*
 * Decompiled with CFR 0.152.
 */
package com.sun.zip;

import com.sun.xfile.XFile;
import com.sun.zip.ZipURL;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class XFileAccessor
implements com.sun.xfile.XFileAccessor {
    private XFile xf;
    private InputStream iStream;
    private long fp;
    private ZipFile zf;
    private ZipEntry ze;
    private String path;
    private ZipURL zu;
    private Enumeration zipList;

    @Override
    public boolean open(XFile xf, boolean serial, boolean readOnly) {
        this.xf = xf;
        try {
            this.zu = new ZipURL(xf.getAbsolutePath());
            this.zf = new ZipFile(this.zu.getLocation());
            this.zipList = this.zf.entries();
            this.path = this.zu.getPath();
            if (this.path != null && !this.path.equals("")) {
                this.ze = this.zf.getEntry(this.path);
                if (this.ze == null) {
                    this.path = this.path + "/";
                    this.ze = this.zf.getEntry(this.path);
                }
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public XFile getXFile() {
        return this.xf;
    }

    @Override
    public boolean exists() {
        return this.ze != null;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        String dirPath;
        if (this.ze != null) {
            return this.ze.isDirectory();
        }
        String string = dirPath = this.path.endsWith("/") ? this.path : this.path + "/";
        while (this.zipList.hasMoreElements()) {
            ZipEntry z = (ZipEntry)this.zipList.nextElement();
            if (!z.getName().startsWith(dirPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFile() {
        if (this.ze != null) {
            return !this.ze.isDirectory();
        }
        return !this.isDirectory();
    }

    @Override
    public long lastModified() {
        return this.ze.getTime();
    }

    @Override
    public long length() {
        return this.ze.getSize();
    }

    @Override
    public boolean mkfile() {
        return false;
    }

    @Override
    public boolean mkdir() {
        return false;
    }

    @Override
    public boolean renameTo(XFile dest) {
        return false;
    }

    @Override
    public String[] list() {
        String dirPath = this.path.endsWith("/") ? this.path : this.path + "/";
        int plen = dirPath.length();
        String[] s = new String[8];
        int i = 0;
        while (this.zipList.hasMoreElements()) {
            ZipEntry z = (ZipEntry)this.zipList.nextElement();
            String zname = z.getName();
            if (!zname.startsWith(dirPath)) continue;
            int slash = zname.indexOf(47, plen);
            if (slash < 0) {
                slash = zname.length();
            }
            s[i++] = zname.substring(plen, slash);
            if (i < s.length) continue;
            String[] tmp = s;
            s = new String[i * 2];
            System.arraycopy(tmp, 0, s, 0, i);
        }
        if (i < s.length) {
            String[] tmp = s;
            s = new String[i];
            System.arraycopy(tmp, 0, s, 0, i);
        }
        return s;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public int read(byte[] b, int off, int len, long foff) throws IOException {
        int c;
        if (this.iStream == null) {
            this.iStream = this.zf.getInputStream(this.ze);
        }
        if (foff > this.fp) {
            this.iStream.skip(foff - this.fp);
            this.fp = foff;
        }
        if ((c = this.iStream.read(b, off, len)) > 0) {
            this.fp += (long)c;
        }
        return c;
    }

    @Override
    public void write(byte[] b, int off, int len, long foff) throws IOException {
        throw new IOException("write not supported");
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.iStream != null) {
            this.iStream.close();
        }
    }

    public String toString() {
        return this.zu.toString();
    }
}

