/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xfile;

import java.net.MalformedURLException;

class XFurl {
    private String url;
    private String protocol;
    private String location;
    private String path;

    XFurl(String url) throws MalformedURLException {
        this.url = url = url.trim();
        int end = url.length();
        int p = url.indexOf(58);
        if (p < 0) {
            throw new MalformedURLException("colon expected");
        }
        this.protocol = url.substring(0, p);
        int q = p++;
        if (url.regionMatches(p, "//", 0, 2)) {
            q = url.indexOf(47, p += 2);
            if (q < 0) {
                q = end;
            }
            this.location = url.substring(p, q);
        }
        String string = this.path = q < end ? url.substring(q + 1, end) : "";
        while (this.path.endsWith("/")) {
            this.path = this.path.substring(0, this.path.length() - 1);
        }
    }

    XFurl(XFurl base, String rpath) throws MalformedURLException {
        this.protocol = base.getProtocol();
        this.location = base.getLocation();
        this.path = base.getPath();
        rpath = rpath.trim();
        if (rpath.indexOf("://") > 0) {
            this.url = rpath;
            XFurl u = new XFurl(rpath);
            this.protocol = u.getProtocol();
            this.location = u.getLocation();
            this.path = u.getPath();
        } else if (rpath.startsWith("/")) {
            this.path = rpath.substring(1);
        } else {
            int p2;
            String npath = "";
            int len = rpath.length();
            int p1 = 0;
            while (true) {
                if ((p2 = rpath.indexOf(37, p1)) < 0) {
                    p2 = len;
                }
                npath = npath + rpath.substring(p1, p2);
                if (p2 >= len) break;
                npath = npath + "%25";
                p1 = p2 + 1;
            }
            rpath = npath;
            len = rpath.length();
            String bpath = base.getPath();
            p1 = 0;
            while (p1 <= len) {
                String component;
                p2 = rpath.indexOf("/", p1);
                if (p2 < 0) {
                    p2 = len;
                }
                if (!(component = rpath.substring(p1, p2)).equals(".") && !component.equals("")) {
                    int q;
                    bpath = component.equals("..") ? ((q = bpath.lastIndexOf("/")) < 0 ? "" : bpath.substring(0, q)) : (bpath.equals("") ? component : bpath + "/" + component);
                }
                p1 = p2 + 1;
            }
            this.path = bpath;
        }
    }

    String getProtocol() {
        return this.protocol;
    }

    String getLocation() {
        return this.location;
    }

    String getPath() {
        return this.path;
    }

    String getParent() {
        int index;
        if (this.path.equals("")) {
            return null;
        }
        String s = this.protocol + ":";
        if (this.location != null) {
            s = s + "//" + this.location;
        }
        if ((index = this.path.lastIndexOf(47)) >= 0) {
            s = s + "/" + this.path.substring(0, index);
        }
        return s;
    }

    String getName() {
        int index = this.path.lastIndexOf(47);
        return index < 0 ? this.path : this.path.substring(index + 1);
    }

    public String toString() {
        String s = this.protocol + ":";
        if (this.location != null) {
            s = s + "//" + this.location;
        }
        if (this.path != null) {
            s = s + "/" + this.path;
        }
        return s;
    }
}

